/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

public class SchedulerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class schedulerFactoryClass = class$org$quartz$impl$StdSchedulerFactory == null ? (class$org$quartz$impl$StdSchedulerFactory = SchedulerFactoryBean.class$("org.quartz.impl.StdSchedulerFactory")) : class$org$quartz$impl$StdSchedulerFactory;
    private String schedulerName;
    private Resource configLocation;
    private Properties quartzProperties;
    private List jobDetails;
    private Map calendars;
    private List triggers;
    private Scheduler scheduler;
    static /* synthetic */ Class class$org$quartz$impl$StdSchedulerFactory;
    static /* synthetic */ Class class$org$quartz$Scheduler;

    public void setSchedulerFactoryClass(Class schedulerFactoryClass) {
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = Arrays.asList(jobDetails);
    }

    public void setCalendars(Map calendars) {
        this.calendars = calendars;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = Arrays.asList(triggers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IOException, SchedulerException {
        Iterator<Object> it;
        SchedulerFactory schedulerFactory = (SchedulerFactory)BeanUtils.instantiateClass(this.schedulerFactoryClass);
        if (this.configLocation != null || this.quartzProperties != null) {
            if (!(schedulerFactory instanceof StdSchedulerFactory)) {
                throw new IllegalArgumentException("StdSchedulerFactory required for applying Quartz properties");
            }
            Properties props = new Properties();
            if (this.configLocation != null) {
                InputStream is = this.configLocation.getInputStream();
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            if (this.quartzProperties != null) {
                props.putAll((Map<?, ?>)this.quartzProperties);
            }
            ((StdSchedulerFactory)schedulerFactory).initialize(props);
        }
        this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
        if (this.jobDetails != null) {
            it = this.jobDetails.iterator();
            while (it.hasNext()) {
                JobDetail jobDetail = (JobDetail)it.next();
                this.scheduler.addJob(jobDetail, true);
            }
        } else {
            this.jobDetails = new ArrayList();
        }
        if (this.calendars != null) {
            it = this.calendars.keySet().iterator();
            while (it.hasNext()) {
                String calendarName = (String)it.next();
                Calendar calendar = (Calendar)this.calendars.get(calendarName);
                this.scheduler.addCalendar(calendarName, calendar, true);
            }
        }
        if (this.triggers != null) {
            it = this.triggers.iterator();
            while (it.hasNext()) {
                JobDetail jobDetail;
                Trigger trigger = (Trigger)it.next();
                if (trigger instanceof JobDetailAwareTrigger && !this.jobDetails.contains(jobDetail = ((JobDetailAwareTrigger)trigger).getJobDetail())) {
                    this.jobDetails.add(jobDetail);
                    this.scheduler.addJob(jobDetail, true);
                }
                this.scheduler.scheduleJob(trigger);
            }
        }
        this.logger.info((Object)"Starting Quartz Scheduler");
        this.scheduler.start();
    }

    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        if (schedulerName != null) {
            return schedulerFactory.getScheduler(schedulerName);
        }
        return schedulerFactory.getScheduler();
    }

    public Object getObject() {
        return this.scheduler;
    }

    public Class getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : (class$org$quartz$Scheduler == null ? (class$org$quartz$Scheduler = SchedulerFactoryBean.class$("org.quartz.Scheduler")) : class$org$quartz$Scheduler);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws SchedulerException {
        this.logger.info((Object)"Shutting down Quartz Scheduler");
        this.scheduler.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

