package spring.sample.aop.introduction;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;

/**
 * Spring AOP introductioñTvł<br>
 * <PRE>
 *   IMameC^tF[X̋ۃNXMame
 *   IMame2C^tF[X̋ۃNXMame2TvłB
 * </PRE>
 * @author MBeans
 * @version 1.0
 */
public class IntroductionSample {

	public static void main(String[] args) {
		try {
			
			Mame mame = new Mame();
			DelegatingIntroductionInterceptor interceptor = new DelegatingIntroductionInterceptor(new Mame2());
			//MameMame2
			ProxyFactory factory = new ProxyFactory(mame);
			factory.addAdvisor(new DefaultIntroductionAdvisor(interceptor));

			//vLVIuWFNg擾
			Object o = factory.getProxy();

			//AOP̑ΏۂƂ(Proxy FactorỹRXgN^Ŏw肵)MameNX̋@\gp
			System.out.print("Mame.foo() : ");
			((IMame) o).foo();

			//Mame2NX̋@\gp
			 ((IMame2) o).in("JavaWorld");
			System.out.println("IMame2.out() : " + ((IMame2) o).out());

		} catch (Exception e) {
			e.printStackTrace();
		}
	}



}
