/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.SMTPclient;

public class ApplicationUI
extends JFrame {
    private static SMTPclient smtpClient = null;
    private boolean useSystemTray = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonQuit;
    private JCheckBox jCheckBoxEnableRemoteConnect;
    private JCheckBox jCheckBoxIsSjis;
    private JCheckBox jCheckBoxLdap;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanelLDAP;
    private JPanel jPanelMail;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldAttribute;
    private JTextField jTextFieldBaseDn;
    private JTextField jTextFieldProviderUrl;
    private JTextField jTextFieldReceiverPort;
    private JTextField jTextFieldServerHost;
    private JTextField jTextFieldServerPort;

    public ApplicationUI() {
        this.initComponents();
        this.resetDisplay();
    }

    private void resetDisplay() {
        this.jTextFieldReceiverPort.setText(Integer.toString(ApplicationProperties.getSmtpPort()));
        this.jTextFieldServerHost.setText(ApplicationProperties.getSmtpServerHost());
        this.jTextFieldServerPort.setText(Integer.toString(ApplicationProperties.getSmtpServerPort()));
        this.jCheckBoxEnableRemoteConnect.setSelected(ApplicationProperties.getSmtpEnebleRemoteConnect());
        this.jCheckBoxLdap.setSelected(ApplicationProperties.getLdap());
        this.jTextFieldProviderUrl.setText(ApplicationProperties.getLdapProviderURL());
        this.jTextFieldBaseDn.setText(ApplicationProperties.getLdapRoot());
        this.jTextFieldAttribute.setText(ApplicationProperties.getLdapAttributes());
        this.jCheckBoxIsSjis.setSelected(ApplicationProperties.getLdapIsSjis());
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelMail = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldReceiverPort = new JTextField();
        this.jTextFieldServerHost = new JTextField();
        this.jTextFieldServerPort = new JTextField();
        this.jCheckBoxEnableRemoteConnect = new JCheckBox();
        this.jPanelLDAP = new JPanel();
        this.jCheckBoxLdap = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldProviderUrl = new JTextField();
        this.jTextFieldBaseDn = new JTextField();
        this.jTextFieldAttribute = new JTextField();
        this.jCheckBoxIsSjis = new JCheckBox();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonQuit = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Mail Destination Confirm Properties");
        this.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent evt) {
                ApplicationUI.this.formWindowDeiconified(evt);
            }

            public void windowIconified(WindowEvent evt) {
                ApplicationUI.this.formWindowIconified(evt);
            }
        });
        this.jLabel1.setText("Receiver Port:");
        this.jLabel2.setText("Mail Server:");
        this.jLabel3.setText("Port:");
        this.jTextFieldReceiverPort.setText("8725");
        this.jTextFieldReceiverPort.setToolTipText("Mail Destination Confirmer SMTP port number.");
        this.jTextFieldServerHost.setText("mail");
        this.jTextFieldServerHost.setToolTipText("Mail server host name or IP address.");
        this.jTextFieldServerPort.setText("25");
        this.jTextFieldServerPort.setToolTipText("Mail server port number.");
        this.jCheckBoxEnableRemoteConnect.setText("Enable remote connect");
        this.jCheckBoxEnableRemoteConnect.setToolTipText("Enable remote machine access this service. (Usually: disable)");
        this.jCheckBoxEnableRemoteConnect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEnableRemoteConnect.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanelMailLayout = new GroupLayout(this.jPanelMail);
        this.jPanelMail.setLayout(jPanelMailLayout);
        jPanelMailLayout.setHorizontalGroup(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().addContainerGap().add(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jTextFieldReceiverPort, -1, 112, Short.MAX_VALUE).addPreferredGap(0).add(this.jCheckBoxEnableRemoteConnect)).add(jPanelMailLayout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jTextFieldServerHost, -1, 170, Short.MAX_VALUE).addPreferredGap(0).add(this.jLabel3).addPreferredGap(0).add(this.jTextFieldServerPort, -2, 54, -2))).addContainerGap()));
        jPanelMailLayout.linkSize(new Component[]{this.jLabel1, this.jLabel2}, 1);
        jPanelMailLayout.setVerticalGroup(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().addContainerGap().add(jPanelMailLayout.createParallelGroup(3).add(this.jLabel1).add(this.jCheckBoxEnableRemoteConnect).add(this.jTextFieldReceiverPort, -2, -1, -2)).addPreferredGap(0).add(jPanelMailLayout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel3).add(this.jTextFieldServerHost, -2, -1, -2).add(this.jTextFieldServerPort, -2, -1, -2)).addContainerGap(74, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("Mail", this.jPanelMail);
        this.jCheckBoxLdap.setText("Enable LDAP search");
        this.jCheckBoxLdap.setToolTipText("Enable LDAP configration.");
        this.jCheckBoxLdap.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxLdap.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxLdap.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ApplicationUI.this.jCheckBoxLdapStateChanged(evt);
            }
        });
        this.jLabel4.setText("URL:");
        this.jLabel5.setText("Root DN:");
        this.jLabel6.setText("Attribute:");
        this.jTextFieldProviderUrl.setText("ldap://localhost:389/");
        this.jTextFieldProviderUrl.setToolTipText("LDAP server URL.");
        this.jTextFieldProviderUrl.setEnabled(false);
        this.jTextFieldBaseDn.setText("C=JP");
        this.jTextFieldBaseDn.setToolTipText("LDAP search start DN.");
        this.jTextFieldBaseDn.setEnabled(false);
        this.jTextFieldAttribute.setText("cn");
        this.jTextFieldAttribute.setToolTipText("Display Attribuite.  Example: cn title;lang-ja-jp");
        this.jTextFieldAttribute.setEnabled(false);
        this.jCheckBoxIsSjis.setText("Force SJIS");
        this.jCheckBoxIsSjis.setToolTipText("Check this, when LDAP server use Shift JIS on network.");
        this.jCheckBoxIsSjis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxIsSjis.setEnabled(false);
        this.jCheckBoxIsSjis.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanelLDAPLayout = new GroupLayout(this.jPanelLDAP);
        this.jPanelLDAP.setLayout(jPanelLDAPLayout);
        jPanelLDAPLayout.setHorizontalGroup(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().add(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().addContainerGap().add(jPanelLDAPLayout.createParallelGroup(1).add(2, this.jLabel6).add(2, this.jLabel5).add(2, this.jLabel4)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(1).add(this.jTextFieldAttribute, -1, 300, Short.MAX_VALUE).add(this.jTextFieldBaseDn, -1, 300, Short.MAX_VALUE).add(jPanelLDAPLayout.createSequentialGroup().add(this.jTextFieldProviderUrl, -1, 217, Short.MAX_VALUE).addPreferredGap(0).add(this.jCheckBoxIsSjis)))).add(jPanelLDAPLayout.createSequentialGroup().add(12, 12, 12).add(this.jCheckBoxLdap))).addContainerGap()));
        jPanelLDAPLayout.linkSize(new Component[]{this.jLabel4, this.jLabel5, this.jLabel6}, 1);
        jPanelLDAPLayout.setVerticalGroup(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().addContainerGap().add(this.jCheckBoxLdap).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel4).add(this.jTextFieldProviderUrl, -2, -1, -2).add(this.jCheckBoxIsSjis)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel5).add(this.jTextFieldBaseDn, -2, -1, -2)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel6).add(this.jTextFieldAttribute, -2, -1, -2)).addContainerGap(28, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("LDAP", this.jPanelLDAP);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonQuit.setText("Quit");
        this.jButtonQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonQuitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jTabbedPane).add(2, layout.createSequentialGroup().addContainerGap().add(this.jButtonQuit).addPreferredGap(0, 145, Short.MAX_VALUE).add(this.jButtonOK).addPreferredGap(0).add(this.jButtonCancel).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK, this.jButtonQuit}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jTabbedPane).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonCancel).add(this.jButtonOK).add(this.jButtonQuit)).addContainerGap()));
        this.pack();
    }

    private void formWindowDeiconified(WindowEvent evt) {
        this.setTitle("Mail Destination Confirm Properties");
    }

    private void formWindowIconified(WindowEvent evt) {
        this.setTitle("mdc");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int serverPort;
        int port;
        try {
            port = Integer.parseInt(this.jTextFieldReceiverPort.getText());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            port = ApplicationProperties.getSmtpPort();
            this.jTextFieldReceiverPort.setText(Integer.toString(port));
        }
        String serverHost = this.jTextFieldServerHost.getText();
        try {
            serverPort = Integer.parseInt(this.jTextFieldServerPort.getText());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            serverPort = ApplicationProperties.getSmtpServerPort();
            this.jTextFieldServerPort.setText(Integer.toString(serverPort));
        }
        boolean enableRemoteConnect = this.jCheckBoxEnableRemoteConnect.isSelected();
        boolean enableLdap = this.jCheckBoxLdap.isSelected();
        String ldapUrl = this.jTextFieldProviderUrl.getText();
        String rootDn = this.jTextFieldBaseDn.getText();
        String attribute = this.jTextFieldAttribute.getText();
        boolean isSjis = this.jCheckBoxIsSjis.isSelected();
        if (!(port == ApplicationProperties.getSmtpPort() && serverHost.equals(ApplicationProperties.getSmtpServerHost()) && serverPort == ApplicationProperties.getSmtpServerPort() && enableRemoteConnect == ApplicationProperties.getSmtpEnebleRemoteConnect() && enableLdap == ApplicationProperties.getLdap() && ldapUrl.equals(ApplicationProperties.getLdapProviderURL()) && rootDn.equals(ApplicationProperties.getLdapRoot()) && attribute.equals(ApplicationProperties.getLdapAttributes()) && isSjis == ApplicationProperties.getLdapIsSjis() && !this.isModifiedPotition())) {
            ApplicationProperties.setSmtpPort(port);
            ApplicationProperties.setSmtpServerHost(serverHost);
            ApplicationProperties.setSmtpServerPort(serverPort);
            ApplicationProperties.setSmtpEnableRemoteConnect(enableRemoteConnect);
            ApplicationProperties.setLdap(enableLdap);
            ApplicationProperties.setLdapProviderURL(ldapUrl);
            ApplicationProperties.setLdapRoot(rootDn);
            ApplicationProperties.setLdapAttributes(attribute);
            ApplicationProperties.setLdapIsSjis(isSjis);
            smtpClient.configChangeNotify();
            if (!ApplicationProperties.save()) {
                // empty if block
            }
        }
        this.iconified();
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jCheckBoxLdapStateChanged(ChangeEvent evt) {
        boolean check = this.jCheckBoxLdap.isSelected();
        this.jTextFieldProviderUrl.setEnabled(check);
        this.jTextFieldBaseDn.setEnabled(check);
        this.jTextFieldAttribute.setEnabled(check);
        this.jCheckBoxIsSjis.setEnabled(check);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.resetDisplay();
        this.iconified();
    }

    private boolean isModifiedPotition() {
        int x = 0;
        int y = 0;
        if (this.getExtendedState() == 0) {
            Point locationPoint = this.getLocationOnScreen();
            x = locationPoint.x;
            y = locationPoint.y;
        } else {
            x = this.getX();
            y = this.getY();
        }
        int h = this.getHeight();
        int w = this.getWidth();
        boolean modified = false;
        if (x != ApplicationProperties.getConfigDialogPosX() || y != ApplicationProperties.getConfigDialogPosY() || h != ApplicationProperties.getConfigDialogPosH() || w != ApplicationProperties.getConfigDialogPosW()) {
            modified = true;
            ApplicationProperties.setConfigDialogPosX(x);
            ApplicationProperties.setConfigDialogPosY(y);
            ApplicationProperties.setConfigDialogPosH(h);
            ApplicationProperties.setConfigDialogPosW(w);
        }
        return modified;
    }

    private boolean initSystemTray() {
        boolean useSystemTray = false;
        try {
            Class.forName("java.awt.SystemTray");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return useSystemTray;
    }

    private void iconified() {
        if (this.useSystemTray) {
            this.setVisible(false);
        } else {
            this.setExtendedState(1);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                ApplicationUI applicationUI = new ApplicationUI();
                applicationUI.setVisible(true);
                applicationUI.useSystemTray = applicationUI.initSystemTray();
                if (ApplicationProperties.isFileLoaded()) {
                    int x = ApplicationProperties.getConfigDialogPosX();
                    int y = ApplicationProperties.getConfigDialogPosY();
                    int w = ApplicationProperties.getConfigDialogPosW();
                    int h = ApplicationProperties.getConfigDialogPosH();
                    if (x > screenSize.width && (x = screenSize.width - w) < 0) {
                        x = 0;
                    }
                    if (y > screenSize.height && (y = screenSize.height - h) < 0) {
                        y = 0;
                    }
                    applicationUI.setBounds(x, y, w, h);
                    applicationUI.iconified();
                } else {
                    Dimension frameSize = ApplicationProperties.getConfigurationDialogSize();
                    if (frameSize.height > screenSize.height) {
                        frameSize.height = screenSize.height;
                    }
                    if (frameSize.width > screenSize.width) {
                        frameSize.width = screenSize.width;
                    }
                    applicationUI.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
                }
            }
        });
        smtpClient = new SMTPclient();
    }
}

