/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.MessageDialogUI;
import org.jent.checksmtp.SMTPclient;

public class ApplicationUI
extends JFrame {
    private static MessageDialogUI portNumberOutOfRangeErrorDialog = null;
    private static MessageDialogUI timeoutRangeErrorDialog = null;
    private static SMTPclient smtpClient = null;
    private boolean useSystemTray = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonQuit;
    private JCheckBox jCheckBoxEnableRemoteConnect;
    private JCheckBox jCheckBoxIsSjis;
    private JCheckBox jCheckBoxLdap;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelProgramName;
    private JLabel jLabelProgramVersion;
    private JLabel jLabelSfURL;
    private JPanel jPanelAbout;
    private JPanel jPanelLDAP;
    private JPanel jPanelMail;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldAttribute;
    private JTextField jTextFieldBaseDn;
    private JTextField jTextFieldConfirmTimeout;
    private JTextField jTextFieldProviderUrl;
    private JTextField jTextFieldReceiverPort;
    private JTextField jTextFieldServerHost;
    private JTextField jTextFieldServerPort;

    public ApplicationUI() {
        this.initComponents();
        this.jButtonOK.requestFocusInWindow();
        this.resetDisplay();
    }

    private void resetDisplay() {
        this.jTextFieldReceiverPort.setText(Integer.toString(ApplicationProperties.getSmtpPort()));
        this.jTextFieldServerHost.setText(ApplicationProperties.getSmtpServerHost());
        this.jTextFieldServerPort.setText(Integer.toString(ApplicationProperties.getSmtpServerPort()));
        this.jCheckBoxEnableRemoteConnect.setSelected(ApplicationProperties.getSmtpEnebleRemoteConnect());
        this.jTextFieldConfirmTimeout.setText(Integer.toString(ApplicationProperties.getConfirmTimeout()));
        this.jCheckBoxLdap.setSelected(ApplicationProperties.getLdap());
        this.jTextFieldProviderUrl.setText(ApplicationProperties.getLdapProviderURL());
        this.jTextFieldBaseDn.setText(ApplicationProperties.getLdapRoot());
        this.jTextFieldAttribute.setText(ApplicationProperties.getLdapAttributes());
        this.jCheckBoxIsSjis.setSelected(ApplicationProperties.getLdapIsSjis());
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelMail = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldReceiverPort = new JTextField();
        this.jTextFieldServerHost = new JTextField();
        this.jTextFieldServerPort = new JTextField();
        this.jCheckBoxEnableRemoteConnect = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jTextFieldConfirmTimeout = new JTextField();
        this.jPanelLDAP = new JPanel();
        this.jCheckBoxLdap = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldProviderUrl = new JTextField();
        this.jTextFieldBaseDn = new JTextField();
        this.jTextFieldAttribute = new JTextField();
        this.jCheckBoxIsSjis = new JCheckBox();
        this.jPanelAbout = new JPanel();
        this.jLabelProgramName = new JLabel();
        this.jLabelProgramVersion = new JLabel();
        this.jLabelSfURL = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonQuit = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jent/checksmtp/Bundle");
        this.setTitle(bundle.getString("ApplicationUI.title"));
        this.setIconImage(this.loadImageIcon());
        this.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent evt) {
                ApplicationUI.this.formWindowDeiconified(evt);
            }

            public void windowIconified(WindowEvent evt) {
                ApplicationUI.this.formWindowIconified(evt);
            }
        });
        this.jLabel1.setText(bundle.getString("ApplicationUI.jLabel1.text"));
        this.jLabel2.setText(bundle.getString("ApplicationUI.jLabel2.text"));
        this.jLabel3.setText(bundle.getString("ApplicationUI.jLabel3.text"));
        this.jTextFieldReceiverPort.setText(bundle.getString("ApplicationUI.jTextFieldReceiverPort.text"));
        this.jTextFieldReceiverPort.setToolTipText(bundle.getString("ApplicationUI.jTextFieldReceiverPort.toolTipText"));
        this.jTextFieldReceiverPort.setInputVerifier(new PortNumberInputVerifier());
        this.jTextFieldReceiverPort.setMinimumSize(new Dimension(44, 19));
        this.jTextFieldServerHost.setText(bundle.getString("ApplicationUI.jTextFieldServerHost.text"));
        this.jTextFieldServerHost.setToolTipText(bundle.getString("ApplicationUI.jTextFieldServerHost.toolTipText"));
        this.jTextFieldServerHost.setMinimumSize(new Dimension(88, 19));
        this.jTextFieldServerPort.setText(bundle.getString("ApplicationUI.jTextFieldServerPort.text"));
        this.jTextFieldServerPort.setToolTipText(bundle.getString("ApplicationUI.jTextFieldServerPort.toolTipText"));
        this.jTextFieldServerPort.setInputVerifier(new PortNumberInputVerifier());
        this.jTextFieldServerPort.setMinimumSize(new Dimension(44, 19));
        this.jCheckBoxEnableRemoteConnect.setText(bundle.getString("ApplicationUI.jCheckBoxEnableRemoteConnect.text"));
        this.jCheckBoxEnableRemoteConnect.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxEnableRemoteConnect.toolTipText"));
        this.jCheckBoxEnableRemoteConnect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEnableRemoteConnect.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel7.setText(bundle.getString("ApplicationUI.jLabel7.text"));
        this.jTextFieldConfirmTimeout.setText(bundle.getString("ApplicationUI.jTextFieldConfirmTimeout.text"));
        this.jTextFieldConfirmTimeout.setToolTipText(bundle.getString("ApplicationUI.jTextFieldConfirmTimeout.toolTipText"));
        this.jTextFieldConfirmTimeout.setInputVerifier(new TimeoutNumberInputVerifier());
        this.jTextFieldConfirmTimeout.setMinimumSize(new Dimension(1, 19));
        GroupLayout jPanelMailLayout = new GroupLayout(this.jPanelMail);
        this.jPanelMail.setLayout(jPanelMailLayout);
        jPanelMailLayout.setHorizontalGroup(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().addContainerGap().add(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jTextFieldReceiverPort, -1, 51, Short.MAX_VALUE).addPreferredGap(0).add(this.jCheckBoxEnableRemoteConnect, -2, 207, -2)).add(jPanelMailLayout.createSequentialGroup().add(this.jLabel7).addPreferredGap(0).add(this.jTextFieldConfirmTimeout, -1, 237, Short.MAX_VALUE).addPreferredGap(0)).add(2, jPanelMailLayout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jTextFieldServerHost, -1, 143, Short.MAX_VALUE).addPreferredGap(0).add(this.jLabel3).addPreferredGap(0).add(this.jTextFieldServerPort, -1, 69, Short.MAX_VALUE).addPreferredGap(0))).addContainerGap()));
        jPanelMailLayout.linkSize(new Component[]{this.jLabel1, this.jLabel2}, 1);
        jPanelMailLayout.setVerticalGroup(jPanelMailLayout.createParallelGroup(1).add(jPanelMailLayout.createSequentialGroup().addContainerGap().add(jPanelMailLayout.createParallelGroup(3).add(this.jLabel1).add(this.jTextFieldReceiverPort, -2, -1, -2).add(this.jCheckBoxEnableRemoteConnect)).addPreferredGap(0).add(jPanelMailLayout.createParallelGroup(3).add(this.jLabel2).add(this.jTextFieldServerHost, -2, -1, -2).add(this.jLabel3).add(this.jTextFieldServerPort, -2, -1, -2)).addPreferredGap(0, 27, Short.MAX_VALUE).add(jPanelMailLayout.createParallelGroup(3).add(this.jLabel7).add(this.jTextFieldConfirmTimeout, -2, -1, -2)).addContainerGap()));
        this.jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelMail.TabConstraints.tabTitle"), null, this.jPanelMail, bundle.getString("ApplicationUI.jPanelMail.TabConstraints tabToolTip"));
        this.jCheckBoxLdap.setText(bundle.getString("ApplicationUI.jCheckBoxLdap.text"));
        this.jCheckBoxLdap.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxLdap.toolTipText"));
        this.jCheckBoxLdap.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxLdap.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxLdap.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ApplicationUI.this.jCheckBoxLdapStateChanged(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("ApplicationUI.jLabel4.text"));
        this.jLabel5.setText(bundle.getString("ApplicationUI.jLabel5.text"));
        this.jLabel6.setText(bundle.getString("ApplicationUI.jLabel6.text"));
        this.jTextFieldProviderUrl.setText(bundle.getString("ApplicationUI.jTextFieldProviderUrl.text"));
        this.jTextFieldProviderUrl.setToolTipText(bundle.getString("ApplicationUI.jTextFieldProviderUrl.toolTipText"));
        this.jTextFieldProviderUrl.setEnabled(false);
        this.jTextFieldBaseDn.setText(bundle.getString("ApplicationUI.jTextFieldBaseDn.text"));
        this.jTextFieldBaseDn.setToolTipText(bundle.getString("ApplicationUI.jTextFieldBaseDn.toolTipText"));
        this.jTextFieldBaseDn.setEnabled(false);
        this.jTextFieldAttribute.setText(bundle.getString("ApplicationUI.jTextFieldAttribute.text"));
        this.jTextFieldAttribute.setToolTipText(bundle.getString("ApplicationUI.jTextFieldAttribute.toolTipText"));
        this.jTextFieldAttribute.setEnabled(false);
        this.jCheckBoxIsSjis.setText(bundle.getString("ApplicationUI.jCheckBoxIsSjis.text"));
        this.jCheckBoxIsSjis.setToolTipText(bundle.getString("ApplicationUI.jCheckBoxIsSjis.toolTipText"));
        this.jCheckBoxIsSjis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxIsSjis.setEnabled(false);
        this.jCheckBoxIsSjis.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanelLDAPLayout = new GroupLayout(this.jPanelLDAP);
        this.jPanelLDAP.setLayout(jPanelLDAPLayout);
        jPanelLDAPLayout.setHorizontalGroup(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().add(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().addContainerGap().add(jPanelLDAPLayout.createParallelGroup(1).add(2, this.jLabel6).add(2, this.jLabel5).add(2, this.jLabel4)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(1).add(this.jTextFieldAttribute, -1, 288, Short.MAX_VALUE).add(this.jTextFieldBaseDn, -1, 288, Short.MAX_VALUE).add(jPanelLDAPLayout.createSequentialGroup().add(this.jTextFieldProviderUrl, -1, 205, Short.MAX_VALUE).addPreferredGap(0).add(this.jCheckBoxIsSjis)))).add(jPanelLDAPLayout.createSequentialGroup().add(12, 12, 12).add(this.jCheckBoxLdap))).addContainerGap()));
        jPanelLDAPLayout.linkSize(new Component[]{this.jLabel4, this.jLabel5, this.jLabel6}, 1);
        jPanelLDAPLayout.setVerticalGroup(jPanelLDAPLayout.createParallelGroup(1).add(jPanelLDAPLayout.createSequentialGroup().addContainerGap().add(this.jCheckBoxLdap).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel4).add(this.jTextFieldProviderUrl, -2, -1, -2).add(this.jCheckBoxIsSjis)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel5).add(this.jTextFieldBaseDn, -2, -1, -2)).addPreferredGap(0).add(jPanelLDAPLayout.createParallelGroup(3).add(this.jLabel6).add(this.jTextFieldAttribute, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelLDAP.TabConstraints.tabTitle"), null, this.jPanelLDAP, bundle.getString("ApplicationUI.jPanelLDAP.TabConstraints tabToolTip"));
        this.jLabelProgramName.setFont(new Font("Dialog", 1, 18));
        this.jLabelProgramName.setText(bundle.getString("ApplicationUI.jLabelProgramName.text"));
        this.jLabelProgramVersion.setFont(new Font("Dialog", 1, 18));
        this.jLabelProgramVersion.setText(bundle.getString("ApplicationUI.jLabelProgramVersion.text"));
        this.jLabelSfURL.setFont(new Font("Dialog", 1, 14));
        this.jLabelSfURL.setText(bundle.getString("ApplicationUI.jLabelSfURL.text"));
        GroupLayout jPanelAboutLayout = new GroupLayout(this.jPanelAbout);
        this.jPanelAbout.setLayout(jPanelAboutLayout);
        jPanelAboutLayout.setHorizontalGroup(jPanelAboutLayout.createParallelGroup(1).add(jPanelAboutLayout.createSequentialGroup().add(jPanelAboutLayout.createParallelGroup(1).add(jPanelAboutLayout.createSequentialGroup().addContainerGap().add(this.jLabelProgramName).addPreferredGap(0).add(this.jLabelProgramVersion)).add(jPanelAboutLayout.createSequentialGroup().add(55, 55, 55).add(this.jLabelSfURL))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelAboutLayout.setVerticalGroup(jPanelAboutLayout.createParallelGroup(1).add(jPanelAboutLayout.createSequentialGroup().addContainerGap().add(jPanelAboutLayout.createParallelGroup(3).add(this.jLabelProgramName).add(this.jLabelProgramVersion, -2, 22, -2)).addPreferredGap(0).add(this.jLabelSfURL).addContainerGap(57, Short.MAX_VALUE)));
        this.jTabbedPane.addTab(bundle.getString("ApplicationUI.jPanelAbout.TabConstraints.tabTitle"), null, this.jPanelAbout, bundle.getString("ApplicationUI.jPanelAbout.TabConstraints tabToolTip"));
        this.jButtonOK.setText(bundle.getString("ApplicationUI.jButtonOK.text"));
        this.jButtonOK.setToolTipText(bundle.getString("ApplicationUI.jButtonOK.toolTipText"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText(bundle.getString("ApplicationUI.jButtonCancel.text"));
        this.jButtonCancel.setToolTipText(bundle.getString("ApplicationUI.jButtonCancel.toolTipText"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonQuit.setText(bundle.getString("ApplicationUI.jButtonQuit.text"));
        this.jButtonQuit.setToolTipText(bundle.getString("ApplicationUI.jButtonQuit.toolTipText"));
        this.jButtonQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationUI.this.jButtonQuitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jButtonQuit).addPreferredGap(0, 133, Short.MAX_VALUE).add(this.jButtonOK).addPreferredGap(0).add(this.jButtonCancel).addContainerGap()).add(this.jTabbedPane, -1, 388, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK, this.jButtonQuit}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jTabbedPane, -1, 141, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jButtonQuit).add(this.jButtonCancel).add(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void formWindowDeiconified(WindowEvent evt) {
        this.setTitle(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.title"));
        this.jButtonOK.requestFocusInWindow();
    }

    private void formWindowIconified(WindowEvent evt) {
        this.setTitle(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.shortTitle"));
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int confirmTimeout;
        int serverPort;
        int port;
        try {
            port = Integer.parseInt(this.jTextFieldReceiverPort.getText());
            this.checkPortRange(port);
        }
        catch (NumberFormatException ex) {
            this.jTextFieldReceiverPort.setBackground(Color.PINK);
            throw ex;
        }
        String serverHost = this.jTextFieldServerHost.getText();
        try {
            serverPort = Integer.parseInt(this.jTextFieldServerPort.getText());
            this.checkPortRange(serverPort);
        }
        catch (NumberFormatException ex) {
            this.jTextFieldServerPort.setBackground(Color.PINK);
            throw ex;
        }
        boolean enableRemoteConnect = this.jCheckBoxEnableRemoteConnect.isSelected();
        try {
            confirmTimeout = Integer.parseInt(this.jTextFieldConfirmTimeout.getText());
            this.checkTimeoutRange(confirmTimeout);
        }
        catch (NumberFormatException nfEx) {
            this.jTextFieldConfirmTimeout.setBackground(Color.PINK);
            throw nfEx;
        }
        boolean enableLdap = this.jCheckBoxLdap.isSelected();
        String ldapUrl = this.jTextFieldProviderUrl.getText();
        String rootDn = this.jTextFieldBaseDn.getText();
        String attribute = this.jTextFieldAttribute.getText();
        boolean isSjis = this.jCheckBoxIsSjis.isSelected();
        if (!(port == ApplicationProperties.getSmtpPort() && serverHost.equals(ApplicationProperties.getSmtpServerHost()) && serverPort == ApplicationProperties.getSmtpServerPort() && enableRemoteConnect == ApplicationProperties.getSmtpEnebleRemoteConnect() && confirmTimeout == ApplicationProperties.getConfirmTimeout() && enableLdap == ApplicationProperties.getLdap() && ldapUrl.equals(ApplicationProperties.getLdapProviderURL()) && rootDn.equals(ApplicationProperties.getLdapRoot()) && attribute.equals(ApplicationProperties.getLdapAttributes()) && isSjis == ApplicationProperties.getLdapIsSjis() && !this.isModifiedPotition())) {
            ApplicationProperties.setSmtpPort(port);
            ApplicationProperties.setSmtpServerHost(serverHost);
            ApplicationProperties.setSmtpServerPort(serverPort);
            ApplicationProperties.setSmtpEnableRemoteConnect(enableRemoteConnect);
            ApplicationProperties.setConfirmTimeout(confirmTimeout);
            ApplicationProperties.setLdap(enableLdap);
            ApplicationProperties.setLdapProviderURL(ldapUrl);
            ApplicationProperties.setLdapRoot(rootDn);
            ApplicationProperties.setLdapAttributes(attribute);
            ApplicationProperties.setLdapIsSjis(isSjis);
            smtpClient.configChangeNotify();
            if (!ApplicationProperties.save()) {
                new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.error.Fail_the_properties_file_save."), null, 0);
            } else {
                this.iconified();
            }
        } else {
            this.iconified();
        }
    }

    private void checkTimeoutRange(int confirmTimeout) throws NumberFormatException {
        if (confirmTimeout < 0) {
            throw new NumberFormatException(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.exception.Timeout_need_to_a_positive_number"));
        }
    }

    private void checkPortRange(int port) {
        if (port <= 0 || port > 65535) {
            throw new NumberFormatException(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.error.Out_of_range."));
        }
    }

    private void jButtonQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jCheckBoxLdapStateChanged(ChangeEvent evt) {
        boolean check = this.jCheckBoxLdap.isSelected();
        this.jTextFieldProviderUrl.setEnabled(check);
        this.jTextFieldBaseDn.setEnabled(check);
        this.jTextFieldAttribute.setEnabled(check);
        this.jCheckBoxIsSjis.setEnabled(check);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.resetDisplay();
        if (portNumberOutOfRangeErrorDialog != null && portNumberOutOfRangeErrorDialog.isVisible()) {
            portNumberOutOfRangeErrorDialog.dispose();
        }
        this.iconified();
    }

    private boolean isModifiedPotition() {
        int x = 0;
        int y = 0;
        if (this.getExtendedState() == 0) {
            Point locationPoint = this.getLocationOnScreen();
            x = locationPoint.x;
            y = locationPoint.y;
        } else {
            x = this.getX();
            y = this.getY();
        }
        int h = this.getHeight();
        int w = this.getWidth();
        boolean modified = false;
        if (x != ApplicationProperties.getConfigDialogPosX() || y != ApplicationProperties.getConfigDialogPosY() || h != ApplicationProperties.getConfigDialogPosH() || w != ApplicationProperties.getConfigDialogPosW()) {
            modified = true;
            ApplicationProperties.setConfigDialogPosX(x);
            ApplicationProperties.setConfigDialogPosY(y);
            ApplicationProperties.setConfigDialogPosH(h);
            ApplicationProperties.setConfigDialogPosW(w);
        }
        return modified;
    }

    private boolean initSystemTray() {
        boolean useSystemTray = false;
        try {
            Class.forName("java.awt.SystemTray");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return useSystemTray;
    }

    private void iconified() {
        if (this.useSystemTray) {
            this.setVisible(false);
        } else {
            this.setExtendedState(1);
        }
    }

    private Image loadImageIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/mdc-icon16x16.png"), ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.jLabelProgramName.text"));
        return imageIcon.getImage();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                ApplicationUI applicationUI = new ApplicationUI();
                applicationUI.setVisible(true);
                applicationUI.useSystemTray = applicationUI.initSystemTray();
                if (ApplicationProperties.isFileLoaded()) {
                    int x = ApplicationProperties.getConfigDialogPosX();
                    int y = ApplicationProperties.getConfigDialogPosY();
                    int w = ApplicationProperties.getConfigDialogPosW();
                    int h = ApplicationProperties.getConfigDialogPosH();
                    if (x > screenSize.width && (x = screenSize.width - w) < 0) {
                        x = 0;
                    }
                    if (y > screenSize.height && (y = screenSize.height - h) < 0) {
                        y = 0;
                    }
                    applicationUI.setBounds(x, y, w, h);
                    applicationUI.iconified();
                } else {
                    Dimension frameSize = ApplicationProperties.getConfigurationDialogSize();
                    if (frameSize.height > screenSize.height) {
                        frameSize.height = screenSize.height;
                    }
                    if (frameSize.width > screenSize.width) {
                        frameSize.width = screenSize.width;
                    }
                    applicationUI.setBounds((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2, frameSize.width, frameSize.height);
                }
            }
        });
        smtpClient = new SMTPclient();
    }

    class TimeoutNumberInputVerifier
    extends InputVerifier {
        TimeoutNumberInputVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            boolean ret = true;
            String input = jTextField.getText();
            try {
                int timeout = Integer.parseInt(input);
                ApplicationUI.this.checkTimeoutRange(timeout);
            }
            catch (Exception e) {
                ret = false;
            }
            if (!ret) {
                jTextField.setBackground(Color.PINK);
                if (timeoutRangeErrorDialog == null) {
                    timeoutRangeErrorDialog = new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.exception.Timeout_need_to_a_positive_number"), null, 1);
                } else {
                    timeoutRangeErrorDialog.setVisible(true);
                }
            } else {
                jTextField.setBackground(Color.WHITE);
            }
            return ret;
        }
    }

    class PortNumberInputVerifier
    extends InputVerifier {
        PortNumberInputVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            boolean ret = true;
            String input = jTextField.getText();
            try {
                int port = Integer.parseInt(input);
                ApplicationUI.this.checkPortRange(port);
            }
            catch (Exception e) {
                ret = false;
            }
            if (!ret) {
                jTextField.setBackground(Color.PINK);
                if (portNumberOutOfRangeErrorDialog == null) {
                    portNumberOutOfRangeErrorDialog = new MessageDialogUI(ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("ApplicationUI.Port_number_is_integer_from_1_to_65535."), null, 1);
                } else {
                    portNumberOutOfRangeErrorDialog.setVisible(true);
                }
            } else {
                jTextField.setBackground(Color.WHITE);
            }
            return ret;
        }
    }
}

