/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ResourceBundle;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.MessageDialogUI;
import org.jent.checksmtp.Processer;

public class SMTPclient
implements Runnable {
    private boolean isConfigChange = false;
    private boolean fatalError = false;
    private Thread serviceThread = null;

    public SMTPclient() {
        this.startServiceThread();
    }

    private void startServiceThread() {
        if (this.serviceThread != null && this.serviceThread.isAlive()) {
            return;
        }
        this.isConfigChange = false;
        this.fatalError = false;
        this.serviceThread = new Thread(this);
        this.serviceThread.start();
    }

    public void configChangeNotify() {
        this.isConfigChange = true;
        if (this.serviceThread != null && !this.serviceThread.isAlive()) {
            this.startServiceThread();
        }
    }

    public void run() {
        block11: while (!this.fatalError) {
            ServerSocket server = null;
            try {
                int serverport = ApplicationProperties.getSmtpPort();
                System.err.println("Open SMTP waiting port. " + serverport);
                try {
                    if (ApplicationProperties.getSmtpEnebleRemoteConnect()) {
                        System.out.println("Enable remote connection.");
                        server = new ServerSocket(serverport, 10);
                    } else {
                        server = new ServerSocket(serverport, 10, InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
                    }
                }
                catch (BindException bindEx) {
                    this.fatalError = true;
                    String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Recive_Port_bind_error") + bindEx.getMessage();
                    System.err.println(errorMessage);
                    bindEx.printStackTrace();
                    new MessageDialogUI(errorMessage, bindEx, 0);
                    break;
                }
                catch (IOException e) {
                    this.fatalError = true;
                    String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.IO_Error_Occurred");
                    System.err.println(errorMessage);
                    e.printStackTrace();
                    new MessageDialogUI(errorMessage, e, 0);
                    break;
                }
                catch (IllegalArgumentException iaEx) {
                    this.fatalError = true;
                    String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Argument_Error_Occurted") + iaEx.getMessage();
                    System.err.println(errorMessage);
                    iaEx.printStackTrace();
                    new MessageDialogUI(errorMessage, iaEx, 0);
                    break;
                }
                while (true) {
                    Socket client;
                    server.setSoTimeout(1000);
                    try {
                        client = server.accept();
                    }
                    catch (SocketTimeoutException ex) {
                        if (!this.isConfigChange) continue;
                        System.err.println("Configuration change restart service.");
                        this.isConfigChange = false;
                        server.close();
                        continue block11;
                    }
                    System.err.println("Accept new STMP socket.");
                    Processer processer = new Processer(client);
                    Thread clientThread = new Thread(processer);
                    clientThread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Continure waiting SMTP client.");
                try {
                    server.close();
                }
                catch (IOException ioe) {}
            }
            catch (RuntimeException rEx) {
                this.fatalError = true;
                String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPCLient.error.Runtime_Exception_was_occurred");
                System.err.println(errorMessage);
                new MessageDialogUI(errorMessage, rEx, 0);
                break;
            }
        }
        if (!this.fatalError) {
            String errorMessage = ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Unexpected_service_stoping_ocurreed");
            System.err.println(errorMessage);
            new MessageDialogUI(errorMessage, null, 0);
        }
    }
}

