///////////////////////////////////////////////////////////////////////////////
//
// Splitice 0.x source code.
//
///////////////////////////////////////////////////////////////////////////////
// DI_JAK32.CPP =  DoIt Group / for Jack32.dll function.
///////////////////////////////////////////////////////////////////////////////
// $Id: DI_JAK32.CPP,v 1.1.1.1 2003/08/24 06:32:17 ardry Exp $ 
///////////////////////////////////////////////////////////////////////////////

//This sourcecode is Meltice's DI_ARDLL.CPP Subset.

#include	<windows.h>

#define	DLLNAME		"JACK32.DLL"
#define	CFGDLG_API	"JackConfigDialog"
#define	GETVER_API	"JackGetVersion"
#define	RIPPER_API	"JackRipper"

HINSTANCE hInstDll;

// load Common Archiver's Project DLL (JACK32.DLL only)
//   return true  -> DLL load success!
//   return false -> DLL load failed.
bool jak_load_dll(void)
{
	hInstDll = LoadLibrary(DLLNAME);
	if(hInstDll == NULL) return false;
	return true;
}

// Call archiver DLL config dialog.
//   hDlg     <- HWND hDlg.
bool jak_config_dialog(const HWND hDlg)
{
	typedef bool (WINAPI *PCNFDLGFUNC)(const HWND,LPSTR,const int);
	static char dummybuf[1024];

	if( jak_load_dll() == true)
	{
		PCNFDLGFUNC CfgDlg = (PCNFDLGFUNC)GetProcAddress(hInstDll, CFGDLG_API);
		if(CfgDlg != NULL) // API function ready...
		{
			return (*CfgDlg)(hDlg,dummybuf, 1);
		}
	}
	return false;
}

// Common Archiver's Project DLL versions.
// Ver.1.34 -> return 134.
int jak_get_version(void)
{
	typedef WORD (WINAPI *PGETVERFUNC)();

	if( jak_load_dll() == true)
	{
		PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(hInstDll,GETVER_API);
		if(GetVer != NULL) // API function ready...
		{
			return (int)(*GetVer)();
		}
	}
	return 0;
}

// File Split (JACK32.DLL wrapper...)
//   JackConfigDialog() 's setting available.
DWORD jak_ripper(
	LPCSTR pszFileName,
	LPCSTR pszDirName)
{
	typedef DWORD (WINAPI *PRIPPERFUNC)( LPCSTR, LPCSTR,int, LPCSTR );
	
	if( jak_load_dll() == true)
	{
		PRIPPERFUNC Ripper = (PRIPPERFUNC)GetProcAddress(hInstDll,RIPPER_API);
		if(Ripper != NULL) // API function ready...
		{
			return (DWORD)(*Ripper)(pszFileName,pszDirName,-1,NULL);
		}
	}
	return -1;
	
}