#ifndef DBASE_DISK_H
#define DBASE_DISK_H

#include "debug.h"
#include <vector>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>

using namespace std;

///////////////////////////////////////////////////////////////////////////////
// File
///////////////////////////////////////////////////////////////////////////////
class cFile {
private:
   char* mPath;
   char* mName;
   struct stat mStatBuf;
   struct stat mStatBufLink;
public:
   cFile(char* path, char* name) throw (const char* );
   ~cFile();

   static void* operator new(size_t size) { return MALLOC(size); }
   static void operator delete(void* obj) { FREE(obj); }

   char* Path() { return mPath; }
   char* Name() { return mName; }
   struct stat* StatBuf();

   static bool Exist(char* path) { return access(path, F_OK) == 0; }
   
   ALLOCATED char* Extension();
   ALLOCATED char* DirName();
   ALLOCATED char* NameWithoutExtension();

   bool IsLink() { return S_ISLNK(mStatBuf.st_mode); }
   bool IsDir();
   bool IsExe();

   ALLOCATED char* LinkTo();

   int UID() { return StatBuf()->st_uid; }
   int GID() { return StatBuf()->st_gid; }
   char* User();                               // ԤNULL֤
   char* Group();                              // ԤNULL֤
   
   int Size() { if(IsDir()) return 0; else return StatBuf()->st_size; }
        // 礭
   time_t MTime() { return StatBuf()->st_mtime; }
};

///////////////////////////////////////////////////////////////////////////////
// Directory
///////////////////////////////////////////////////////////////////////////////
class cDir {
private:
   char mPath[PATH_MAX];
   vector<cFile*> mFiles;

   void read() throw(const char*);
public:
   cDir(char* path) throw (const char*);   // pathκǸΥåͭǤ̵ǤɤХѥΤ
   ~cDir();

   static void* operator new(size_t size) { return MALLOC(size); }
   static void operator delete(void* obj) { FREE(obj); }

   ALLOCATED static char* CWD();

   /// Properties ///
   char* Path() { return mPath; }               // pathκǸϥåͭ
   ALLOCATED char* Name();
   vector<cFile*>* Files() { return &mFiles; }
   
   ALLOCATED char* ParentDir();                 // Ǹ˥åͭ
   cFile* FindFileWithName(char* name);

   /// methods ///
   bool Move(char* path);      // ХѥΤ
   bool Reread();
};

#endif
