#include "mystring.h"
#include "mydebug.h"

string_object* string_new(char* str)
{
    string_object* result;
    
    result = MALLOC(sizeof(string_object));
    result->mStr = STRDUP(str);
    result->mLen = strlen(str);

    return result;
}

void string_delete(string_object* str)
{
    FREE(str->mStr);
    
    FREE(str);
}

int string_length(string_object* obj)
{
    return obj->mLen;
}

int string_size(string_object* obj)
{
    return obj->mLen;
}

char* string_c_str(string_object* obj)
{
    return obj->mStr;
}

void string_insert(string_object* obj, int pos, char* str)
{
    char* new_str;
    const int str_len = strlen(str);
    
    new_str = MALLOC(obj->mLen + str_len + 1);

    memcpy(new_str, obj->mStr, pos);
    memcpy(new_str + pos, str, str_len);
    strcpy(new_str + pos + str_len, obj->mStr + pos);

    FREE(obj->mStr);

    obj->mStr = new_str;
}

void string_erase(string_object* obj, int pos, int len)
{
    strcpy(obj->mStr + pos, obj->mStr+pos+len);
}

