#ifndef MCURSES_H
#define MCURSES_H

extern "C"
{
#include <curses.h>
#include <stdarg.h>
}

void myinitscr();
void myendwin();
void mymove(int y, int x);
int mymvprintw(int y, int x, char* str, ...);
int myprintw(char* str, ...);
void myattron(attr_t attrs);
void myattroff(attr_t attrs);
int mygetmaxx();
int mygetmaxy();
void myclear();
void myclear2();
void myclear_online(int y, bool lastline);

#if defined(__CYGWIN__)
void mybox(int y, int x, int width, int height);
#else
void wmybox(WINDOW* wnd, int x, int y, int width, int height);
#endif

void myrefresh();
int mygetch(int* meta);


#endif
