#ifndef MFILER2_COMMON
#define MFILER2_COMMON

extern "C" {
#include "ruby.h"
#include "mlib/mlib.h"
#include "mlib/mdebug.h"
#include "mlib/mlist.h"
#include "mlib/mvector.h"
#include "mlib/mstring.h"
#include "mlib/mhash.h"
#include <termios.h>
}

using namespace std;

/// mcurses.c ///
#include "mcurses.h"

/// menu.cpp ///
#include "menu.h"

extern cMenu* gActiveMenu;
extern hash_obj* gMenu;

/// dirwnd.cpp ///
#include "dirwnd.h"

/// main.cpp ///
extern cDirWnd* gLDir;
extern cDirWnd* gRDir;
extern bool gMainLoop;
extern hash_obj* gKeyCommand[2][KEY_MAX];
extern struct termios gTtySave;
extern bool gGnuScreen;
extern bool gNoPty;
enum eKanjiCode { kEuc, kSjis, kUtf };
extern eKanjiCode gKanjiCode;

bool is_kanji(unsigned char c);
void cut(char* src, char* dest, int len);
void err_msg(char* msg, ...);
void msg(char* msg);
int select_str(char* msg, char* str[], int len, int cancel);
void view();

extern bool gISearch;
extern bool gColor;
extern bool gIndividualCursor;
extern bool gCheckDeleteFile;
extern bool gCheckCopyFile;
extern bool gCheckExit;
extern bool gProcessLine;
extern bool gShiftISearch;
extern char gTrashBoxName[256];

const int kWhite = 1;
const int kBlue = 2;
const int kCyan = 3;
const int kGreen = 4;
const int kYellow = 5;
const int kMagenta = 6;
const int kRed = 7;

/// command.cpp ///
void command_init();
void command_final();

/// cmdline.cpp ///
//const int kOutputSize = 131072;
const int kOutputSize = 65536;
struct sMasterTty
{
    int mFD;
    char mName[1024];
    pid_t mPID;
    
    char mOutput[kOutputSize];
    int mOutputTail;
};

extern vector_obj* gTty;
extern bool gCmdLineActive;   // readonly
extern vector_obj* gCCandidate;;    // readonly

void cmdline_init();
void cmdline_final();
void cmdline_start(char* cmd, int posion);
void cmdline_input(int meta, int key);
void cmdline_view();
void cmdline_completion_view();
void cmdline_run(char* str, char* title);
void cmdline_restore_pty(int n);
int cmdline_select_pty(char* title);

/// file.cpp ///
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel };
extern eCopyOverride gCopyOverride;

bool file_copy(char* spath, char* dpath, bool move);
void file_remove(char* path);

#endif
