#include "common.h"

#if defined(__CYGWIN__)
#include <ncurses/term.h>
#include <termios.h>
#include <sys/ioctl.h>
#endif

void myinitscr()
{
#if defined(__CYGWIN__)
    
    if(setupterm(NULL, STDOUT_FILENO, (int*) 0) == ERR) {
        fprintf(stderr, "invalid TERM setting");
        exit(1);
    }
    
    struct termios t;
    
    tcgetattr(STDIN_FILENO, &t);

#ifdef ECHOPRT
    t.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOCTL | ECHOE| ECHOK | ECHOKE
                         | ECHONL | ECHOPRT);
#else
    t.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOCTL | ECHOE | ECHOK | ECHOKE
                  | ECHONL);
#endif

    t.c_iflag |= IGNBRK;
    t.c_iflag &= ~(IXOFF|IXON);
    t.c_cc[VMIN] = 1;
    t.c_cc[VTIME] = 0;
    tcsetattr(STDIN_FILENO, TCSANOW, &t);
#else
    initscr();
    noecho();
    keypad(stdscr, 1);
    raw();

    if(has_colors() && gColor) {
        start_color();
        gColor = true;
        init_pair(kWhite, COLOR_WHITE, COLOR_BLACK);
        init_pair(kBlue, COLOR_BLUE, COLOR_BLACK);
        init_pair(kCyan, COLOR_CYAN, COLOR_BLACK);
        init_pair(kGreen, COLOR_GREEN, COLOR_BLACK);
        init_pair(kYellow, COLOR_YELLOW, COLOR_BLACK);
        init_pair(kMagenta, COLOR_MAGENTA, COLOR_BLACK);
        init_pair(kRed, COLOR_RED, COLOR_BLACK);
    }
    else {
        gColor = false;
    }
#endif
}

void myendwin()
{
#if defined(__CYGWIN__)
    tcsetattr(STDIN_FILENO, TCSANOW, &gTtySave);
#else
    endwin();
#endif
}

void mymove(int y, int x)
{
#if defined(__CYGWIN__)
    putp(tparm(tigetstr("cup"), y, x));  //printf("\033[%d; %dH", y, x);
#else
    move(y, x);
#endif
}

int mymvprintw(int y, int x, char* str, ...)
{
#if defined(__CYGWIN__)
    char buf[BUFSIZ];
    
    va_list args;
    va_start(args, str);
    vsprintf(buf, str, args);
    va_end(args);
    
    mymove(y, x);

    const int len = strlen(buf);
    int i;
    for(i=0; i<len; i++) {
        putchar(buf[i]);
    }
    
    return i; //strlen(buf);
#else
    char buf[BUFSIZ];

    va_list args;
    va_start(args, str);
    vsprintf(buf, str, args);
    va_end(args);

    return mvprintw(y, x, "%s", buf);
#endif
}

int myprintw(char* str, ...)
{
#if defined(__CYGWIN__)
    char buf[BUFSIZ];
    
    va_list args;
    va_start(args, str);
    vsprintf(buf, str, args);
    va_end(args);

    return printf("%s", buf);
#else
    char buf[BUFSIZ];

    va_list args;
    va_start(args, str);
    vsprintf(buf, str, args);
    va_end(args);

    return printw("%s", buf);
#endif
}

void myattron(attr_t attrs)
{
#if defined(__CYGWIN__)
    if(attrs & A_REVERSE) {
        putp(tigetstr("rev")); //printf("\033[07m");
    }
    else if(attrs & A_BOLD) {
        putp(tigetstr("bold")); //printf("\033[01m");
    }
#else
    attron(attrs);
#endif
}

void myattroff(attr_t attrs)
{
#if defined(__CYGWIN__)
    putp(tigetstr("sgr0")); //printf("\033[0m");
#else
    attroff(attrs);
#endif
}

int mygetmaxx()
{
#if defined(__CYGWIN__)
    struct winsize ws;
    ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws);

    return ws.ws_col;
#else
    return getmaxx(stdscr);
#endif
}

int mygetmaxy()
{
#if defined(__CYGWIN__)
    struct winsize ws;
    ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws);

    return ws.ws_row;
#else
    return getmaxy(stdscr);
#endif
}

void myclear()
{
#if defined(__CYGWIN__)
  putp(tigetstr("clear"));
#else
  clear();
#endif
}

void myclear2()
{
   char space[1024];
   int x, y;

   const int maxx = mygetmaxx();
   
   for(x=0; x<mygetmaxx(); x++) {
      space[x] = ' ';
   }
   space[x] = 0;
    
   const int maxy = mygetmaxy();
   for(y=0; y<maxy; y++) {
      mymvprintw(y, 0, space);
   }

}

void myclear_online(int y, bool lastline)
{
    char space[1024];
    int x;

    const int maxx = mygetmaxx();
#if !defined(__CYGWIN__)
    for(x=0; x<maxx; x++) {
        space[x] = ' ';
    }
#else
    if(lastline) {
        for(x=0; x<maxx-1; x++) {
            space[x] = ' ';
        }
    }
    else {
        for(x=0; x<maxx; x++) {
            space[x] = ' ';
        }
    }
#endif
    space[x] = 0;
    
    mymvprintw(y, 0, space);
}

#if defined(__CYGWIN__)
void mybox(int y, int x, int width, int height)
{
   char hbar[256];
   int i;
   
   hbar[0] = '+';
   for(i=1; i<width-1; i++) {
      hbar[i] = '-';
   }
   hbar[i] = '+';
   hbar[i+1] = 0;

   mymvprintw(y, x, hbar);
   for(i=0; i<height-2; i++) {
      mymvprintw(y + 1 + i, x, "|");
      mymvprintw(y + 1 + i, x + width-1, "|");
   }
   mymvprintw(y + height-1, x, hbar);
}
#else
void wmybox(WINDOW* wnd, int x, int y, int width, int height)
{
   char hbar[256];
   int i;

   hbar[0] = '+';
   for(i=1; i<width-1; i++) {
      hbar[i] = '-';
   }
   hbar[i] = '+';
   hbar[i+1] = 0;

   mvwprintw(wnd, y, x, hbar);
   for(i=0; i<height-2; i++) {
      mvwprintw(wnd, y + 1 + i, x, "|");
      mvwprintw(wnd, y + 1 + i, x + width-1, "|");
   }
   mvwprintw(wnd, y + height-1, x, hbar);
}
#endif

void myrefresh()
{
#if defined(__CYGWIN__)
    fflush(stdout);
#else
    refresh();
#endif
}

int mygetch(int* meta)
{
    *meta = 0;
    
#if defined(__CYGWIN__)
    char buf[256];
    read(STDIN_FILENO, buf, 1);
    if(buf[0] == 27) {
        read(STDIN_FILENO, buf, 1);

        if(buf[0] == 27) {
            read(STDIN_FILENO, buf, 1);

            if(buf[0] == 91) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 49) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_HOME;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 50) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_IC;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 51) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_DC;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 52) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_END;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 53) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_PPAGE;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 54) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        *meta = 1;
                        return KEY_NPAGE;
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 68) {
                    *meta = 1;
                    return KEY_LEFT;
                }
                else if(buf[0] == 67) {
                    *meta = 1;
                    return KEY_RIGHT;
                }
                else if(buf[0] == 65) {
                    *meta = 1;
                    return KEY_UP;
                }
                else if(buf[0] == 66) {
                    *meta = 1;
                    return KEY_DOWN;
                }
                else {
                    return buf[0];
                }
            }
            else {
                return buf[0];
            }
        }
        else if(buf[0] == 91) {
            read(STDIN_FILENO, buf, 1);

            if(buf[0] == 68) {
                return KEY_LEFT;
            }
            else if(buf[0] == 67) {
                return KEY_RIGHT;
            }
            else if(buf[0] == 65) {
                return KEY_UP;
            }
            else if(buf[0] == 66) {
                return KEY_DOWN;
            }
            else if(buf[0] == 49) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 55) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(6);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 56) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(7);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 57) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(8);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 126) {
                    return KEY_HOME;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 50) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 48) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(9);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 49) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(10);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 51) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(11);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 52) {
                    read(STDIN_FILENO, buf, 1);

                    if(buf[0] == 126) {
                        return KEY_F(12);
                    }
                    else {
                        return buf[0];
                    }
                }
                else if(buf[0] == 126) {
                    return KEY_IC;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 51) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 126) {
                    return KEY_DC;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 52) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 126) {
                    return KEY_END;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 53) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 126) {
                    return KEY_PPAGE;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 54) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 126) {
                    return KEY_NPAGE;
                }
                else {
                    return buf[0];
                }
            }
            else if(buf[0] == 91) {
                read(STDIN_FILENO, buf, 1);

                if(buf[0] == 65) {
                    return KEY_F(1);
                }
                else if(buf[0] == 66) {
                    return KEY_F(2);
                }
                else if(buf[0] == 67) {
                    return KEY_F(3);
                }
                else if(buf[0] == 68) {
                    return KEY_F(4);
                }
                else if(buf[0] == 69) {
                    return KEY_F(5);
                }
                else {
                    return buf[0];
                }
            }
            else {
                return buf[0];
            }
        }
        else {
            *meta = 1;
            return buf[0];
        }
    }
    return buf[0];
#else
    int key = getch();
    if(key == 27) {
        int key2 = getch();

        *meta = 1;
        return key2;
    }
    else {
        return key;
    }
#endif
}


