/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll3d;

import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.GLUT;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.SwingUtilities;
import javax.xml.bind.JAXBElement;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.DefaultMidiEventHandler;
import org.rz.midiplayer.context.MidiChannelEventAdaptor;
import org.rz.midiplayer.context.MidiChannelEventListener;
import org.rz.midiplayer.context.MidiEventHandler;
import org.rz.midiplayer.plugin.renderer.RendererPlugin;
import org.rz.midiplayer.util.PathUtil;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayerplugin.renderer.pianoroll3d.LightInfo;
import org.rz.midiplayerplugin.renderer.pianoroll3d.LoadCameraAction;
import org.rz.midiplayerplugin.renderer.pianoroll3d.NoteObject;
import org.rz.midiplayerplugin.renderer.pianoroll3d.Point3D;
import org.rz.midiplayerplugin.renderer.pianoroll3d.Process;
import org.rz.midiplayerplugin.renderer.pianoroll3d.StoreCameraAction;
import org.rz.midiplayerplugin.renderer.pianoroll3d.config.Camera;
import org.rz.midiplayerplugin.renderer.pianoroll3d.config.Color;
import org.rz.midiplayerplugin.renderer.pianoroll3d.config.Config;
import org.rz.midiplayerplugin.renderer.pianoroll3d.config.Position;
import org.rz.midiplayerplugin.renderer.pianoroll3d.config.Renderer;

public class PianorollRenderer
implements RendererPlugin,
GLEventListener {
    static final boolean ENABLED_MULTITHREAD = true;
    static final int NOTE_OBJ_NUM = 1024;
    private Context context;
    private String pluginDir;
    private final Dimension screenSize = new Dimension(512, 384);
    private DefaultMidiEventHandler midiEventHandler;
    private final LinkedList<NoteObject> masterObjList = new LinkedList();
    private final LinkedList<NoteObject> activeObjList = new LinkedList();
    private final Process process = new Process(this.masterObjList, this.activeObjList);
    public static final java.awt.Color[] DEFAULT_COLORS = new java.awt.Color[]{new java.awt.Color(8388564), new java.awt.Color(11591910), new java.awt.Color(16767673), new java.awt.Color(16752762), new java.awt.Color(10025880), new java.awt.Color(0xFFFF00), new java.awt.Color(16766720), new java.awt.Color(0xEE82EE), new java.awt.Color(15684210), new java.awt.Color(13789470), new java.awt.Color(64154), new java.awt.Color(0x7FFF00), new java.awt.Color(16113331), new java.awt.Color(16758465), new java.awt.Color(16716947), new java.awt.Color(49151), new java.awt.Color(12092939), new java.awt.Color(16737095)};
    private final java.awt.Color[] pianoRollColors = new java.awt.Color[16];
    private final float[] gridColor = new float[]{0.1f, 0.1f, 0.1f, 1.0f};
    private final float[] gridNormal = new float[]{0.0f, 1.0f, 0.0f};
    private static final float[] matAmbient = new float[]{0.2f, 0.2f, 0.2f};
    private static final float[] matSpecular = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[] matShininess = new float[]{16.0f};
    private GLCanvas canvas;
    private final GLUT glut = new GLUT();
    private FPSAnimator animator;
    private final java.awt.Color TEXT_COLOR = new java.awt.Color(255, 255, 255, 128);
    private final TextRenderer text = new TextRenderer(new Font("Monospaced", 0, 12));
    private final ArrayList<LoadCameraAction> execLoadCameraList = new ArrayList();
    private final ArrayList<StoreCameraAction> execStoreCameraList = new ArrayList();
    private Point3D[] cameraPointList;
    private Point3D currentCamera;
    private int lastCameraIndex;
    private final LightInfo light = new LightInfo();
    private int lastX = -1;
    private int lastY = -1;
    private boolean visibleCameraPosition = false;
    private boolean visibleGrid = true;
    private JAXBElement<Config> configRootElement;

    public void onInit(Context ctx, String pluginDir) {
        this.context = ctx;
        this.pluginDir = pluginDir;
        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        this.canvas = new GLCanvas(caps);
        this.canvas.setPreferredSize(new Dimension(512, 384));
        this.canvas.addGLEventListener((GLEventListener)this);
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                PianorollRenderer.this.onMouseWheelMoved(e);
            }
        });
        this.canvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PianorollRenderer.this.onKeyPressed(e);
            }
        });
        this.canvas.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PianorollRenderer.this.onMouseDragged(e);
            }
        });
        this.midiEventHandler = new DefaultMidiEventHandler(ctx);
        this.midiEventHandler.addMidiChannelEventListener((MidiChannelEventListener)new MidiChannelEventAdaptor(){

            public void noteOff(int ch, int note) {
                PianorollRenderer.this.noteOff(ch, note);
            }

            public void noteOn(int ch, int note, int vel) {
                PianorollRenderer.this.noteOn(ch, note, vel);
            }
        });
        ctx.addMidiEventHandler((MidiEventHandler)this.midiEventHandler);
        try {
            int i;
            for (i = 0; i < 16; ++i) {
                this.pianoRollColors[i] = DEFAULT_COLORS[i];
            }
            JAXBUtil jaxbConfig = new JAXBUtil(Config.class);
            this.configRootElement = jaxbConfig.loadFromFile(PathUtil.package2ClasspathString(this.getClass()) + "/config.xsd", PathUtil.buildPath((String)pluginDir, (String)"config.xml"));
            Config config = (Config)this.configRootElement.getValue();
            for (Color c : config.getPianoroll().getColor()) {
                try {
                    java.awt.Color col;
                    short ch = c.getMidich();
                    this.pianoRollColors[ch] = col = java.awt.Color.decode(c.getColor());
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to loading a config file", e);
                }
            }
            this.visibleCameraPosition = config.getRenderer().isViewPosition();
            this.visibleGrid = config.getRenderer().isViewGrid();
            List<Position> posList = config.getRenderer().getCamera().getPosition();
            this.cameraPointList = new Point3D[posList.size()];
            for (i = 0; i < posList.size(); ++i) {
                this.cameraPointList[i] = new Point3D();
                this.cameraPointList[i].tx = posList.get(i).getTx();
                this.cameraPointList[i].ty = posList.get(i).getTy();
                this.cameraPointList[i].tz = posList.get(i).getTz();
                this.cameraPointList[i].rx = posList.get(i).getRx();
                this.cameraPointList[i].ry = posList.get(i).getRy();
                this.cameraPointList[i].rz = posList.get(i).getRz();
            }
            this.currentCamera = new Point3D();
            this.lastCameraIndex = Math.min(config.getRenderer().getCamera().getLastUsed(), posList.size() - 1);
            this.cameraPointList[this.lastCameraIndex].copyTo(this.currentCamera);
            i = 0;
            for (Position p : posList) {
                LoadCameraAction loadAct = new LoadCameraAction(this.currentCamera, p);
                this.execLoadCameraList.add(loadAct);
                StoreCameraAction storeAct = new StoreCameraAction(p, this.currentCamera);
                this.execStoreCameraList.add(storeAct);
                ++i;
            }
            this.animator = new FPSAnimator((GLAutoDrawable)this.canvas, (int)config.getRenderer().getFps(), true);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to loading a config file", e);
        }
    }

    public void startRendering() {
        this.process.start();
        this.animator.start();
    }

    public void stopRendering() {
        this.process.stop();
        this.animator.stop();
        this.canvas.removeGLEventListener((GLEventListener)this);
    }

    public Component getComponent() {
        return this.canvas;
    }

    public void onMidiPlayingBefore(File midiFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMidiStoped() {
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject o : this.activeObjList) {
                o.noteOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOn(int ch, int noteNo, int vel) {
        LinkedList<NoteObject> linkedList = this.masterObjList;
        synchronized (linkedList) {
            LinkedList<NoteObject> linkedList2 = this.activeObjList;
            synchronized (linkedList2) {
                NoteObject no = !this.masterObjList.isEmpty() ? this.masterObjList.removeFirst() : this.activeObjList.removeFirst();
                no.reset();
                no.setColor(this.pianoRollColors[ch]);
                no.noteOn(0.78125f * (float)(64 - noteNo), 1.0f * (float)ch, vel);
                no.noteNo = noteNo;
                no.channel = ch;
                this.activeObjList.addLast(no);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void noteOff(int ch, int noteNo) {
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject no : this.activeObjList) {
                if (no.channel != ch || no.noteNo != noteNo) continue;
                no.noteOff();
            }
        }
    }

    public synchronized void onDispose(Context ctx) {
        ctx.removeMidiEventHandler((MidiEventHandler)this.midiEventHandler);
        try {
            if (this.configRootElement != null) {
                logger.info("Save to config file");
                Renderer r = ((Config)this.configRootElement.getValue()).getRenderer();
                Camera c = r.getCamera();
                r.setViewGrid(this.visibleGrid);
                r.setViewPosition(this.visibleCameraPosition);
                c.setLastUsed((short)this.lastCameraIndex);
                JAXBUtil jaxbConfig = new JAXBUtil(Config.class);
                jaxbConfig.writeToFile(this.configRootElement, PathUtil.package2ClasspathString(this.getClass()) + "/config.xsd", new File(PathUtil.buildPath((String)this.pluginDir, (String)"config.xml")));
                logger.info("Save to config file successfully");
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Failed to save config..", e);
        }
    }

    private void update(GL gl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(GL gl) {
        Point3D camera = this.currentCamera;
        float cx = camera.tx;
        float cy = camera.ty;
        float cz = camera.tz;
        float rx = camera.rx;
        float ry = camera.ry;
        float rz = camera.rz;
        LightInfo li = this.light;
        gl.glEnable(2896);
        gl.glEnable(16384);
        gl.glClear(16640);
        gl.glEnable(2929);
        gl.glEnable(2884);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glLightfv(16384, 4611, li.getLightPosition(), 0);
        gl.glLightfv(16384, 4608, li.getLightAmbient(), 0);
        gl.glLightfv(16384, 4610, li.getLightSpecular(), 0);
        gl.glLightfv(16384, 4609, li.getLightDiffuse(), 0);
        gl.glTranslatef(cx, cy, cz);
        gl.glRotatef(rx, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(ry, 0.0f, 1.0f, 0.0f);
        gl.glRotatef(rz, 0.0f, 0.0f, 1.0f);
        if (this.visibleGrid) {
            gl.glPushMatrix();
            float x = 1.5625f;
            gl.glMaterialfv(1028, 4609, this.gridColor, 0);
            gl.glBegin(1);
            for (int i = 0; i < 64; ++i) {
                gl.glNormal3fv(this.gridNormal, 0);
                gl.glVertex3f(x * (float)(32 - i), -1.0f, -250.0f);
                gl.glVertex3f(x * (float)(32 - i), -1.0f, 250.0f);
            }
            gl.glEnd();
            gl.glPopMatrix();
        }
        LinkedList<NoteObject> linkedList = this.activeObjList;
        synchronized (linkedList) {
            for (NoteObject n : this.activeObjList) {
                n.render(gl, this.glut);
            }
        }
        if (this.visibleCameraPosition) {
            this.text.beginRendering(512, 384);
            this.text.setColor(this.TEXT_COLOR);
            this.text.draw("notes:" + this.activeObjList.size(), 0, 72);
            this.text.draw("tx:" + cx, 0, 60);
            this.text.draw("ty:" + cy, 0, 48);
            this.text.draw("tz:" + cz, 0, 36);
            this.text.draw("rx:" + rx, 0, 24);
            this.text.draw("ry:" + ry, 0, 12);
            this.text.draw("rz:" + rz, 0, 0);
            this.text.endRendering();
        }
        gl.glFlush();
    }

    public boolean isEnabledResizeWindow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        LinkedList<NoteObject> linkedList = this.masterObjList;
        synchronized (linkedList) {
            this.masterObjList.clear();
            for (int i = 0; i < 1024; ++i) {
                this.masterObjList.addLast(new NoteObject());
            }
        }
        linkedList = this.activeObjList;
        synchronized (linkedList) {
            this.activeObjList.clear();
        }
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        this.update(gl);
        this.render(gl);
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL gl = drawable.getGL();
        float ratio = (float)height / (float)width;
        gl.glShadeModel(7425);
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glFrustum(-1.0, 1.0, (double)(-ratio), (double)ratio, 3.0, 1000.0);
    }

    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void onKeyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 68) {
            this.currentCamera.tx = 0.0f;
            this.currentCamera.ty = 0.0f;
            this.currentCamera.tz = 0.0f;
            this.currentCamera.rx = 0.0f;
            this.currentCamera.ry = 0.0f;
            this.currentCamera.rz = 0.0f;
        }
        if (keyCode == 71) {
            boolean bl = this.visibleGrid = !this.visibleGrid;
        }
        if (keyCode == 67) {
            boolean bl = this.visibleCameraPosition = !this.visibleCameraPosition;
        }
        if (keyCode == 39) {
            this.currentCamera.tx += 0.5f;
        }
        if (keyCode == 37) {
            this.currentCamera.tx -= 0.5f;
        }
        if (keyCode == 38) {
            if (e.isShiftDown()) {
                this.currentCamera.rx += 1.0f;
            } else if (e.isControlDown()) {
                this.currentCamera.ry += 1.0f;
            } else if (e.isAltDown()) {
                this.currentCamera.rz += 1.0f;
            } else {
                this.currentCamera.ty -= 0.5f;
            }
        }
        if (keyCode == 40) {
            if (e.isShiftDown()) {
                this.currentCamera.rx -= 1.0f;
            } else if (e.isControlDown()) {
                this.currentCamera.ry -= 1.0f;
            } else if (e.isAltDown()) {
                this.currentCamera.rz -= 1.0f;
            } else {
                this.currentCamera.ty += 0.5f;
            }
        }
        int i = -1;
        switch (keyCode) {
            case 49: {
                i = 0;
                break;
            }
            case 50: {
                i = 1;
                break;
            }
            case 51: {
                i = 2;
                break;
            }
            case 52: {
                i = 3;
                break;
            }
            case 53: {
                i = 4;
                break;
            }
            case 54: {
                i = 5;
                break;
            }
            case 55: {
                i = 6;
                break;
            }
            case 56: {
                i = 7;
            }
        }
        if (i >= 0) {
            LoadCameraAction a;
            if (e.isShiftDown()) {
                StoreCameraAction a2;
                StoreCameraAction storeCameraAction = a2 = this.execStoreCameraList.get(i);
                synchronized (storeCameraAction) {
                    a2.exec();
                }
            }
            LoadCameraAction loadCameraAction = a = this.execLoadCameraList.get(i);
            synchronized (loadCameraAction) {
                a.exec();
            }
            this.lastCameraIndex = i;
        }
    }

    private synchronized void onMouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int vx = this.lastX - x;
        int vy = this.lastY - y;
        float add = 0.5f;
        if (SwingUtilities.isLeftMouseButton(e) && e.isAltDown()) {
            if (vx < 0) {
                this.currentCamera.rz += add;
            } else if (vx > 0) {
                this.currentCamera.rz -= add;
            }
        } else if (SwingUtilities.isLeftMouseButton(e) && e.isControlDown()) {
            if (vx < 0) {
                this.currentCamera.ry += add;
            } else if (vx > 0) {
                this.currentCamera.ry -= add;
            }
        } else if (SwingUtilities.isLeftMouseButton(e) && e.isShiftDown()) {
            if (vy < 0) {
                this.currentCamera.rx += add;
            } else if (vy > 0) {
                this.currentCamera.rx -= add;
            }
        } else if (SwingUtilities.isRightMouseButton(e)) {
            if (vx < 0) {
                this.currentCamera.tx += add;
            } else if (vx > 0) {
                this.currentCamera.tx -= add;
            }
            if (vy < 0) {
                this.currentCamera.ty -= add;
            } else if (vy > 0) {
                this.currentCamera.ty += add;
            }
        }
        this.lastX = x;
        this.lastY = y;
    }

    private synchronized void onMouseWheelMoved(MouseWheelEvent e) {
        float rotation = 2.0f * (float)e.getWheelRotation();
        if (e.isShiftDown()) {
            this.currentCamera.rx += rotation;
        } else if (e.isControlDown()) {
            this.currentCamera.ry += rotation;
        } else if (e.isAltDown()) {
            this.currentCamera.rz += rotation;
        } else {
            this.currentCamera.tz += (float)e.getWheelRotation() * 10.0f;
        }
    }
}

