/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.plugin.Plugin;
import org.rz.midiplayer.plugin.info.PluginInfo;
import org.rz.midiplayer.util.PathUtil;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayer.xmlmodule.XSDConstants;
import org.xml.sax.SAXException;

public class PluginManager<PLUGIN_BASE extends Plugin>
implements Loggable {
    protected final String PLUGIN_DIR;
    private Hashtable<PluginInfo, String> pluginInfoList = new Hashtable(64);
    private Hashtable<PluginInfo, Class<?>> pluginList = new Hashtable(64);
    private final Class<PLUGIN_BASE> pluginBaseClass;

    public PluginManager(Class<PLUGIN_BASE> c, String pluginDir) throws IllegalArgumentException, JAXBException, SAXException, IOException, ClassNotFoundException {
        this.PLUGIN_DIR = pluginDir;
        this.pluginBaseClass = c;
        File f = new File(pluginDir);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("pluginDir is not directory : " + pluginDir);
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("pluginDir is not exist : " + pluginDir);
        }
        this.refreshPluginInfo();
        this.loadClasses();
    }

    private void refreshPluginInfo() throws JAXBException, SAXException, IOException {
        logger.info("Searching plugin info (plugin.xml) from " + this.PLUGIN_DIR);
        File dir = new File(this.PLUGIN_DIR);
        File[] dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    File pluginXml = new File(PathUtil.buildPath(pathname.toString(), "plugin.xml"));
                    if (pluginXml.exists()) {
                        Loggable.logger.info("Plugin dir  : " + pathname.getName());
                        return true;
                    }
                    Loggable.logger.info("plugin.xml not found. this directory is ignored:" + pathname);
                    return false;
                }
                return false;
            }
        });
        if (dirs == null || dirs.length == 0) {
            logger.warning("PLUGIN IS EMPTY... : " + this.PLUGIN_DIR);
            return;
        }
        Hashtable<PluginInfo, String> newList = new Hashtable<PluginInfo, String>(64);
        for (File d : dirs) {
            String path = PathUtil.buildPath(d.toString(), "plugin.xml");
            logger.info("Loading plugin info (plugin.xml) from " + path);
            File xml = new File(path);
            newList.put(this.loadPluginInfo(new File(path)), d.getCanonicalPath());
        }
        this.pluginInfoList = newList;
    }

    protected PluginInfo loadPluginInfo(File xmlPath) throws JAXBException, SAXException {
        JAXBUtil<PluginInfo> jaxb = new JAXBUtil<PluginInfo>(PluginInfo.class);
        return (PluginInfo)jaxb.loadFromFile(XSDConstants.PLUGINIFO_XSD_URI, xmlPath).getValue();
    }

    private void loadClasses() throws IOException, ClassNotFoundException {
        Enumeration<PluginInfo> en = this.pluginInfoList.keys();
        this.pluginList.clear();
        while (en.hasMoreElements()) {
            PluginInfo inf = en.nextElement();
            String dir = this.pluginInfoList.get(inf);
            Class<?> claszz = this.loadClass(dir, inf);
            this.pluginList.put(inf, claszz);
        }
    }

    public PLUGIN_BASE newInstance(Context ctx, PluginInfo inf) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = this.pluginList.get(inf);
        Class<PLUGIN_BASE> cc = null;
        if (c == null) {
            throw new ClassNotFoundException("plugin class " + inf.getClazz() + " is not found...");
        }
        cc = c.asSubclass(this.pluginBaseClass);
        Plugin ret = (Plugin)cc.newInstance();
        String pluginDir = this.pluginInfoList.get(inf);
        if (pluginDir == null) {
            throw new IllegalArgumentException("inf is illegal value( pluginDir is null )");
        }
        ret.onInit(ctx, pluginDir);
        return (PLUGIN_BASE)ret;
    }

    private Class<?> loadClass(String dir, PluginInfo inf) throws IOException, ClassNotFoundException {
        logger.info("create instance : " + inf.getClazz());
        File jarFile = new File(PathUtil.buildPath(dir, inf.getJarfile()));
        URL jarURL = jarFile.getCanonicalFile().toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{jarURL});
        Class<?> clazz = loader.loadClass(inf.getClazz());
        for (Class<?> i : clazz.getInterfaces()) {
            if (i != this.pluginBaseClass) continue;
            logger.info("found class <" + clazz.getName() + "> implements " + this.pluginBaseClass.getName());
            return clazz;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (superClass == this.pluginBaseClass) {
                logger.info("found class <" + clazz.getName() + "> extends " + this.pluginBaseClass.getName());
                return clazz;
            }
            for (Class<?> i : superClass.getInterfaces()) {
                if (i != this.pluginBaseClass) continue;
                logger.info("found class <" + clazz.getName() + "> implements " + this.pluginBaseClass.getName());
                return clazz;
            }
            logger.info(superClass.getName());
        }
        throw new ClassNotFoundException();
    }

    public boolean isEmpty() {
        return this.pluginInfoList.isEmpty();
    }

    public boolean existPlugin(String name) {
        for (PluginInfo i : this.pluginInfoList.keySet()) {
            if (!i.getName().equals(name)) continue;
            logger.info("exist plugin : " + name);
            return true;
        }
        return false;
    }

    public PluginInfo getPluginInfo(String name) {
        for (PluginInfo i : this.pluginInfoList.keySet()) {
            logger.info("searching for plugin info, name=" + name + ", inf=" + i.getName());
            if (!i.getName().equals(name)) continue;
            logger.info("exist plugin info : " + name);
            return i;
        }
        return null;
    }

    public synchronized PluginInfo[] getPluginInfoList() {
        PluginInfo[] ret = new PluginInfo[this.pluginInfoList.size()];
        if (!this.pluginInfoList.isEmpty()) {
            int i = 0;
            Iterator<PluginInfo> it = this.pluginInfoList.keySet().iterator();
            while (it.hasNext()) {
                ret[i] = it.next();
                ++i;
            }
        }
        return ret;
    }
}

