/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.rz.midiplayer.logging.LogFormatter;
import org.rz.midiplayer.logging.Loggable;

public class LogWindow
extends JFrame
implements Loggable {
    private JMenuItem clearMenuItem;
    private JMenu editMenu;
    private JMenuBar jMenuBar;
    private JScrollPane jScrollPane;
    private JTextArea jTextArea;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("org.rz.midiplayer.ui.resources.LogWindow");
    private final LogHandler logHandler;

    public LogWindow() {
        this.initComponents();
        this.logHandler = new LogHandler(this.jTextArea);
        logger.addHandler(this.logHandler);
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jMenuBar = new JMenuBar();
        this.editMenu = new JMenu();
        this.clearMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LogWindow.this.onWindowClosed(evt);
            }
        });
        this.jTextArea.setBackground(Color.black);
        this.jTextArea.setColumns(80);
        this.jTextArea.setFont(new Font("Monospaced", 0, 12));
        this.jTextArea.setForeground(Color.white);
        this.jTextArea.setRows(25);
        this.jTextArea.setTabSize(4);
        this.jScrollPane.setViewportView(this.jTextArea);
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.editMenu.setText(this.resourceBundle.getString("editManu.label"));
        this.clearMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.clearMenuItem.setMnemonic('C');
        this.clearMenuItem.setText(this.resourceBundle.getString("editMenu.clearItem.label"));
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogWindow.this.onClearItemAction(evt);
            }
        });
        this.editMenu.add(this.clearMenuItem);
        this.jMenuBar.add(this.editMenu);
        this.setJMenuBar(this.jMenuBar);
        this.pack();
    }

    private void onWindowClosed(WindowEvent evt) {
        logger.removeHandler(this.logHandler);
    }

    private void onClearItemAction(ActionEvent evt) {
        this.jTextArea.setText(null);
    }

    private class LogHandler
    extends Handler {
        private final JTextArea target;
        private final LogFormatter formatter = new LogFormatter();

        public LogHandler(JTextArea target_) {
            this.target = target_;
            this.setFormatter(this.formatter);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            String txt = this.getFormatter().format(record);
            SwingUtilities.invokeLater(new Logging(this.target, txt));
        }

        private class Logging
        implements Runnable {
            final JTextArea target;
            final String message;

            public Logging(JTextArea target_, String msg) {
                this.target = target_;
                this.message = msg;
            }

            @Override
            public void run() {
                this.target.append(this.message);
            }
        }
    }
}

