/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.mitonan.ipsfex.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.gr.java_conf.mitonan.ipsfex.logging.Log;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class OffsetConvertUtil {
    private static Method methodWidgetOffset2ModelOffset;
    private static Method methodModelOffset2WidgetOffset;
    private static Method methodGetSourceViewer;
    private static final Log LOG;

    static {
        LOG = Log.getLog();
        OffsetConvertUtil.createMethodOfWidgetOffset2ModelOffset();
        OffsetConvertUtil.createMethodOfModelOffset2WidgetOffset();
        OffsetConvertUtil.createMethodOfGetSourceViewer();
    }

    private OffsetConvertUtil() {
    }

    public static int widgetOffset2modelOffset(ITextEditor editor, int widgetOffset) {
        int modelOffset = widgetOffset;
        if (editor == null || !(editor instanceof AbstractTextEditor)) {
            return modelOffset;
        }
        try {
            ISourceViewer viewer = OffsetConvertUtil.getSourceViewer(editor);
            modelOffset = (Integer)methodWidgetOffset2ModelOffset.invoke((Object)((AbstractTextEditor)editor), viewer, widgetOffset);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return modelOffset;
    }

    private static void createMethodOfWidgetOffset2ModelOffset() {
        try {
            methodWidgetOffset2ModelOffset = AbstractTextEditor.class.getDeclaredMethod("widgetOffset2ModelOffset", ISourceViewer.class, Integer.TYPE);
            methodWidgetOffset2ModelOffset.setAccessible(true);
        }
        catch (SecurityException ignore) {
            LOG.error("Create Method Error. widgetOffset2ModelOffset()", ignore);
        }
        catch (NoSuchMethodException ignore) {
            LOG.error("Create Method Error. widgetOffset2ModelOffset()", ignore);
        }
    }

    private static void createMethodOfModelOffset2WidgetOffset() {
        try {
            methodModelOffset2WidgetOffset = AbstractTextEditor.class.getDeclaredMethod("modelOffset2WidgetOffset", ISourceViewer.class, Integer.TYPE);
            methodModelOffset2WidgetOffset.setAccessible(true);
        }
        catch (SecurityException ignore) {
            LOG.error("Create Method Error. modelOffset2WidgetOffset()", ignore);
        }
        catch (NoSuchMethodException ignore) {
            LOG.error("Create Method Error. modelOffset2WidgetOffset()", ignore);
        }
    }

    private static ISourceViewer getSourceViewer(ITextEditor editor) {
        ISourceViewer viewer = null;
        try {
            AbstractTextEditor aEditor = null;
            if (editor != null && editor instanceof AbstractTextEditor) {
                aEditor = (AbstractTextEditor)editor;
                viewer = (ISourceViewer)methodGetSourceViewer.invoke((Object)aEditor, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return viewer;
    }

    private static void createMethodOfGetSourceViewer() {
        try {
            methodGetSourceViewer = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            methodGetSourceViewer.setAccessible(true);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

