// -*- mode: c++ -*-

#ifndef MIX_COMMENT_H_
#define MIX_COMMENT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NodeList.h"
#include "Value.h"
#include "extern/noncopyable.hpp"

namespace MiX{
  ///XMLhLg̃Rg\NXł
  template <class charT,class traitsT>
  class Comment : boost::noncopyable,
		  public Value<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Comment<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^.
     *
     * Comment̃RXgN^͒ڌĂׂ܂<br>
     * Comment<...>::createŐĂ
     */
    Comment(const string_type& val) : Value<charT,traitsT>(val) { };
    /**
     * Rs[RXgN^
     *
     * Comment̓Rs[ł܂B
     */
    Comment(const this_type& src){ };

  public:
    ///fXgN^
    virtual ~Comment()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const { return Node_Comment; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_CommentԂ܂
     */
    static NodeType type() { return Node_Comment; } ;
    /**
     * Comment̕\𓾂܂
     *
     * bIndent^Ȃ當iIndentOffsetɎw肳ꂽ
     * XMLTraits::tab()߂l̐擪ɂ܂
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * Comment𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    this_type& clone(element_type& parent,const typename nodelist_type::iterator& it = dmy_it) const 
      { return this_type::create(getValue(),parent,it); };
    /**
     * Comment𐶐܂
     *
     * <dl>
     *   <dt>str</dt><dd>Comment̒l</dd>
     *   <dt>parent</dt><dd>Comment̐eGg</dd>
     *   <dt>it</dt><dd>}ꏊparent.getChilds()̗vfCe[^łȂ΂Ȃ܂</dd>
     * </dl>
     */
    static this_type& create(const string_type& str,element_type& parent,const typename nodelist_type::iterator& it = dmy_it);

    friend class DOM_Parser<charT,traitsT>;

  };
}

#ifndef MIX_COMMENT_CPP_
#include "Comment.cpp"
#endif//MIX_COMMENT_CPP_

#endif
