#define MIX_DOMPARSER_CPP_

#include "DOM_Parser.h"

#include "Attribute.h"
#include "Element.h"

namespace MiX{
  template <class charT,class traitsT>
  void DOM_Parser<charT,traitsT>::onXMLDeclaration(attrmap_type attr){
    typename attrmap_type::iterator it = attr.begin();
    typename attrmap_type::iterator last = attr.end();
    for( ;it!=last;it++){
      attribute_type* attr= new attribute_type(it->first,it->second);
      current_->addChild(attr);
    }
  }
  
  template <class charT,class traitsT>
  void DOM_Parser<charT,traitsT>::onStart(string_type name,attrmap_type attr){
    element_type* el = new element_type(name);
    current_->addChild(el);
    current_ = el;

    typename attrmap_type::iterator it = attr.begin();
    for( ;it!=attr.end();it++){
      attribute_type* att=new attribute_type(it->first,it->second);
      current_->addChild(att);
    }
  }
  
  template <class charT,class traitsT>
  void DOM_Parser<charT,traitsT>::onEnd(string_type name){
    current_ = &(current_->getParent());
  }
  
  template <class charT,class traitsT>
  void DOM_Parser<charT,traitsT>::onText(string_type text){
    text_type* t = new text_type(text);
    current_->addChild(t);
  }
  
  template <class charT,class traitsT>
  void DOM_Parser<charT,traitsT>::onComment(string_type text){
    comment_type* com = new comment_type(text);
    current_->addChild(com);
  }

  template <class charT,class traitsT>
  Document<charT,traitsT>& DOM_Parser<charT,traitsT>::parse(const charT* text){
    parser_.setEventHandler(this);
    document_type* doc = new document_type();
    current_ = doc;
    parser_.parse(text);
    return *doc;
  }  
  template <class charT,class traitsT>
  Document<charT,traitsT>& DOM_Parser<charT,traitsT>::parse(std::basic_istream<charT,char_traits>& is){
    parser_.setEventHandler(this);
    document_type* doc = new document_type();
    current_ = doc;
    parser_.parse(is);
    return *doc;
  }  
}
