// -*- mode: c++ -*-

#ifndef MIX_DOMPARSER_H_
#define MIX_DOMPARSER_H_

#include "classes.h"
#include "DefaultXMLTraits.h"
#include "SAX_Parser.h"

namespace MiX{
  /**
   * ^ꂽ͂ADOMc[\zNX
   *
   * ɂSaxParsergpĂ
   */
  template <class charT,class traitsT>
  class DOM_Parser : public SAX_EventHandler<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef DOM_Parser<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  private:
    ///ۂɃp[WOSaxParser
    SAX_Parser<charT,traitsT> parser_;
    ///ݍ\z̃m[h
    NodeContainer<charT,traitsT>* current_;
  public:
    ///fXgN^
    virtual ~DOM_Parser(){ };
    ///SaxParser̂߂̃nh(p̂)
    virtual void onXMLDeclaration(attrmap_type attr);
    ///SaxParser̂߂̃nh(p̂)
    virtual void onStart(string_type name,attrmap_type attr);
    ///SaxParser̂߂̃nh(p̂)
    virtual void onEnd(string_type name);
    ///SaxParser̂߂̃nh(p̂)
    virtual void onText(string_type text);
    ///SaxParser̂߂̃nh(p̂)
    virtual void onComment(string_type text);

    ///^ꂽƂDOMc[\z܂
    document_type& parse(const charT* text);
    ///^ꂽXg[ƂDOMc[\z܂
    document_type& parse(std::basic_istream<charT, char_traits>& is);

    /**
     * ̑Oɂ(Cfg)𖳎邩ǂݒ肵܂
     *
     * setIgnoreSpace(true)ꍇACfgɂĐ`ꂽ
     * XMLhLgȒPɏ邱Ƃł܂
     */
    void setIgnoreSpace(bool flag){ parser_.setIgnoreSpace(flag); };
  };
}

#ifndef MIX_DOMPARSER_CPP_
#include "DOM_Parser.cpp"
#endif

#endif
