// -*- mode: c++ -*-

#ifndef MIX_DOCUMENT_H_
#define MIX_DOCUMENT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "extern/noncopyable.hpp"

namespace MiX{
  /**
   * XMLhLgŜ\NX
   *
   * ̎qElementƁAAttribute܂
   */
  template <class charT,class traitsT>
  class Document : boost::noncopyable,
		   public NodeContainer<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Document<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  protected:
    /**
     * RXgN^
     *
     * Document̃RXgN^͒ڌĂׂ܂B
     * Document<...>::createŐĂ
     */
    Document() { };
  public:
    ///fXgN^
    virtual ~Document()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType() const{ return Node_Document; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_DocumentԂ܂
     */
    static NodeType type(){ return Node_Document; } ;
    ///B̎qElementԂ܂
    element_type& getRoot()const;
    /**
     * Document̕\𓾂܂
     *
     * SXMLꍇ͂Ăт܂<br>
     * bIndent^̎Cfgǉ܂B
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * qAttributeɃANZX܂
     *
     * szNameŗ^ꂽOAttributeւ̎QƂԂ܂<br>
     * ȂꍇDomException<...>𓊂܂
     */
    attribute_type& operator[](const string_type& name){
      return getAttribute(name);
    }
    /**
     * Document𕡐܂
     */
    this_type& clone()const;
    /**
     * Document𐶐܂
     *
     * DocumentƓɗB̎qElement܂
     * \param rootname ɐqElement̖O
     */
    static this_type& create(const string_type& rootname);
    
    friend class DOM_Parser<charT,traitsT>;
  };
}

#ifndef MIX_DOCUMENT_CPP_
#include "Document.cpp"
#endif

#endif
