#define MIX_ELEMENT_CPP_

#include <iostream>
#include <numeric>

#include "Element.h"
#include "XMLString.h"
#include "DOM_Exception.h"

namespace MiX{
  //dmy_itcreateőOȗ邽߂̃gbN
  template <class charT,class traitsT>
  const typename NodeList<charT,traitsT>::iterator 
  Element<charT,traitsT>::dmy_it=NodeList<charT,traitsT>::iterator();
  
  template <class charT,class traitsT>
  XMLString<charT,traitsT> Element<charT,traitsT>::getText()const{
    string_type ret;
    typename nodelist_type::const_iterator it = getChildren().begin();
    typename nodelist_type::const_iterator last = getChildren().end();
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Text){
	const text_type& txt =dynamic_cast<const text_type&>(**it);
	ret+=txt.getValue();
      }
    }
    return ret;    
  }
  
  template <class charT,class traitsT>
  void Element<charT,traitsT>::setText(const XMLString<charT,traitsT>& s){
    nodelist_type lst = getChildren();
    typename nodelist_type::iterator it = lst.begin();
    typename nodelist_type::iterator last = lst.end();
    
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Text){
	(*it)->destroy(); 
      }
    }
    text_type::create(s,*this);
  };
  
  template <class charT,class traitsT>
  XMLString<charT,traitsT> Element<charT,traitsT>::toString(bool is_indent,int indent_off)const{
    string_type s;
    if(is_indent) insertIndent(indent_off,s,xml_traits::tab());
    s += xml_traits::lt();s += getName();
    typename nodelist_type::const_iterator it = getChildren().begin();
    typename nodelist_type::const_iterator last = getChildren().end();
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Attribute){
	s += xml_traits::sp();
	s += (*it)->toString();
      }
    }
    string_type children;
    bool b = false;
    for(it=getChildren().begin();it!=last;++it){
      if((*it)->getType()!=Node_Attribute){
	b=true; 
	children+=(*it)->toString(is_indent,indent_off+1);
      }
    }
    if(b){
      s += xml_traits::gt(); 
      if(is_indent) s+=xml_traits::crlf();
      s += children;
      if(is_indent) insertIndent(indent_off,s,xml_traits::tab());
      s += xml_traits::lt(); s += xml_traits::slash();
      s += getName(); s += xml_traits::gt();
      if(is_indent) s+=xml_traits::crlf();
    }else{
      s += xml_traits::slash(); s += xml_traits::gt();
      if(is_indent) s+=xml_traits::crlf();
    }
    return s;
  };

  template <class charT,class traitsT>
  Element<charT,traitsT>& Element<charT,traitsT>::clone(element_type& parent,const typename nodelist_type::iterator& it) const {
    element_type& ret = element_type::create(getName(),parent,it);
    
    typename nodelist_type::const_iterator itr = getChildren().begin();
    typename nodelist_type::const_iterator last = getChildren().end();
        for( ; itr != last ; ++itr ){
      // ͉̕...
      if((*itr)->getType()==Node_Element){
	const element_type& el = dynamic_cast<const element_type&>(**itr);
	el.clone(ret);
      }else if((*itr)->getType()==Node_Attribute){
	const attribute_type& att = dynamic_cast<const attribute_type&>(**itr);
	att.clone(ret);
      }else if((*itr)->getType()==Node_Text){
	const text_type& txt = dynamic_cast<const text_type&>(**itr);
	txt.clone(ret);
      }else if((*itr)->getType()==Node_Comment){
	const comment_type& com = dynamic_cast<const comment_type&>(**itr);
	com.clone(ret);
      }else{
	std::ostringstream ss;
	ss << "DOM_Exception" << std::endl
	   << __FILE__ << ':' << __LINE__ << std::endl
	   << "Invalid DOM Tree"<< std::endl << std::ends;
	throw DOM_Exception<charT,traitsT>(this,InvalidNodeFound,ss.str());
      }
    }
    return ret;
  }

  template <class charT,class traitsT>
  Element<charT,traitsT>& Element<charT,traitsT>::create(const string_type& name,element_type& parent,const typename nodelist_type::iterator& it){
    this_type* newel = new this_type(name);
    newel->setParent(parent);
    if(&it==&dmy_it)
      parent.getChildren().insert(parent.getChildren().end(),newel);
    else parent.getChildren().insert(it,newel);
    return *newel;
  }
  
}
