// -*- mode: c++ -*-

#ifndef MIX_TEXT_H_
#define MIX_TEXT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NodeList.h"
#include "extern/noncopyable.hpp"

namespace MiX{
  ///XMLhLg̕킷NXł
  template <class charT,class traitsT>
  class Text : boost::noncopyable,
	       public Value<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Text<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  protected:
    const static typename NodeList<charT,traitsT>::iterator dmy_it;
    /**
     * RXgN^
     *
     * Text̃RXgN^͒ڌĂׂ܂<br>
     * Text<...>::createŐĂ
     */
    Text(const string_type& val) : Value<charT,traitsT>(val){ };
  public:
    ///fXgN^
    virtual ~Text()throw(){ };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const{ return Node_Text; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_TextԂ܂
     */
    static NodeType type(){ return Node_Text; };
    /**
     * Text̕\𓾂܂
     *
     * bIndent^Ȃ當iIndentOffsetɎw肳ꂽ
     * XMLTraits::tab()߂l̐擪ɂ܂B
     */
    virtual string_type toString(bool indent=false,int indent_off=0)const;
    /**
     * Text𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    this_type& clone(element_type& parent,const typename nodelist_type::iterator& it = dmy_it) const 
      { return text_type::create(getValue(),parent,it); };

    /**
     * Text𐶐܂
     *
     * \param str Text̒l
     * \param parent Text̐eGg
     * \param it }ꏊ(parent.getChilds()̗vfCe[^łȂ΂Ȃ܂)
     */
    static this_type& create(const string_type& str,element_type& parent,const typename nodelist_type::iterator& it = dmy_it);

    friend class DOM_Parser<charT,traitsT>;
  };
}

#ifndef MIX_TEXT_CPP_
#include "Text.cpp"
#endif

#endif
