// -*- mode: c++ -*-

#ifndef MIX_XMLTOKEN_H_
#define MIX_XMLTOKEN_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"

namespace MiX{
  enum TokenType{
    Token_null = 0,
    Token_crlf,
    Token_space,
    Token_tab,
    Token_lt,
    Token_eq,
    Token_gt,
    Token_slash,
    Token_hyphen,
    Token_semicolon,
    Token_exclamation,
    Token_question,
    Token_amp,
    Token_dblquote,
    Token_quote,
    Token_text = 100
  };
  /**
   * Tokenizero͂g[N킷NX (pNXł)
   *
   * Ǝg̈ʒuĂ܂
   * ʒu̓G[̎Ɏg܂
   */
  template <class charT,class traitsT>
  class XMLToken {
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef XMLToken<charT,traitsT> this_type;
  private:
    string_type str_;
    TokenType type_;
    long index_;
  public:
    ///RXgN^
    XMLToken() : type_(Token_null),index_(-1){ };
    ///RXgN^
    XMLToken(const charT* first,const charT* last,TokenType type,long index);
    ///𓾂܂
    string_type& getData() { return str_; };
    ///g[N^Cv𓾂܂
    TokenType getType() { return type_; };
    ///ʒu𓾂܂
    long getIndex() { return index_; };
  };
}

#ifndef MIX_XMLTOKEN_CPP_
#include "XMLToken.cpp"
#endif

#endif
