// -*- mode: c++ -*-

#ifndef MIX_ELEMENT_H_
#define MIX_ELEMENT_H_

#include "classes.h"
#include "misc.h"
#include "NodeContainer.h"
#include "extern/noncopyable.hpp"

namespace MiX{
  /**
   * XMLhLg̃Gg\NXł
   *
   * OAq𕡐ێ܂
   */
  template <class charT,class traitsT>
  class Element 
    : boost::noncopyable,
      public NodeContainer<charT,traitsT>, 
      public NamedNode<charT,traitsT>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef Element<charT,traitsT> this_type;
    typedef NodeContainer<charT,traitsT> nodecontainer_type;
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^
     *
     *  Element̃RXgN^͒ڌĂׂ܂<br>
     *  Element<...>::createŐĂ
     */
    Element(const string_type& name)
      : NodeContainer<charT,traitsT>(),
	NamedNode<charT,traitsT>(name){ };
  public:
    /// fXgN^
    virtual ~Element()throw(){ };
    /// ̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const{ return Node_Element; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_ElementԂ܂
     */
    static NodeType type(){ return Node_Element; };
    /**
     * qElementɃANZX܂
     *
     * szNameŗ^ꂽOiIndexԖڂElementւ̎QƂԂ܂
     * ȂꍇDomException<...>𓊂܂
     */
    this_type& operator() (const string_type& name,int index=0){
      return getElement(name,index);
    };
    /**
     * qAttributeɃANZX܂
     *
     * szNameŗ^ꂽOAttributeւ̎QƂԂ܂
     * ȂꍇDomException<...>𓊂܂
     */
    attribute_type& operator[] (const string_type& name){
      return getAttribute(name);
    };
    /**
     * Element̕\𓾂܂
     *
     *  bIndent^̎ACfgǉ܂
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;

    ///qText̒lAĕԂ܂
    string_type getText()const;

    ///qTextSďAs̒lqText𐶐܂B
    void setText(const XMLString<charT,traitsT>& s);
    /**
     * Element𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    this_type& clone(this_type& parent,const typename nodelist_type::iterator& it = dmy_it) const;
    /**
     * Element𐶐܂
     *
     * \param name Element̖O
     * \param parent Element̐em[h
     * \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    static this_type& create(const string_type& name,this_type& parent,const typename nodelist_type::iterator& it = dmy_it);


#ifdef MiX_BACKWARD_COMPATIBILITY //݊ێ
    ///qText̒lAĕԂ܂
    string_type getAllChildValue(){ return getText(); }
#endif

    friend class DOM_Parser<charT,traitsT>;
    friend class Document<charT,traitsT>;
  };
}

#ifndef MIX_ELEMENT_CPP_
#include "Element.cpp"
#endif

#endif
