// -*- mode: C++ -*-
#ifndef MIX_FUNCTIONS_H_
#define MIX_FUNCTIONS_H_

#include "misc.h"
#include "extern/compose.hpp"

#include <functional>

/** \file Functions
 * vO~Oɕ֗Ȋ֐IuWFNg錾Ă܂B
 */

namespace MiX{
  /**
   * NodeType؂vfBP[^
   *
   * RXgN^̃p[^Ƃė^ꂽNodeTypeƁA
   * ֐̃p[^Ƃė^ꂽNodẽ^CvȂΐ^Ԃ܂
   */
  template <class charT,class traitsT>
  class NodeTypeChecker
    : public std::unary_function<const Node<charT,traitsT>*,bool>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef const Node<charT,traitsT>* argument_type;
    typedef bool result_type; 
  private:
    NodeType type_;
  public:
    /// RXgN^
    NodeTypeChecker(NodeType t) : type_(t){ };
    /// nodẽ^Cvƍ\z̃p[^tΐ^
    result_type operator()(argument_type node)const{
      return (node->getType()==type_);
    };
  };

  /**
   * m[h̖O؂vfBP[^
   *
   * RXgN^̃p[^Ƃė^ꂽO
   * ֐̃p[^Ƃė^ꂽNode̖OȂΐ^Ԃ܂
   * ^ꂽNodeNamedNodeł͂Ȃꍇ͋UԂ܂
   */
  template <class charT,class traitsT>
  class NodeNameChecker
    : public std::unary_function<const Node<charT,traitsT>*,bool>{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef const node_type* argument_type;
    typedef bool result_type; 
  private:
    string_type name_;
  public:
    ///RXgN^
    NodeNameChecker(const string_type& name) : name_(name){ };
    ///node̖O\zɗ^ꂽp[^nameƓΐ^
    result_type operator()(argument_type node)const;
  };

  /**
   * m[h̃^CvƖO؂vfBP[^
   *
   * NodeTypeCheckerNodeNameCheckervfBP[^ł
   * w肵^CvƖOm[h鎞ȂǂɎgp܂
   */
  template <class charT,class traitsT>
  class NamedNodeFinder
    : public boost::compose_f_gx_hx_t<std::logical_and<bool>,NodeTypeChecker<charT,traitsT>,NodeNameChecker<charT,traitsT> >{
  public:
    MiX_Template_Typedef(charT,traitsT);
    typedef const node_type* argument_type;
    typedef bool result_type; 
    typedef boost::compose_f_gx_hx_t<std::logical_and<bool>,NodeTypeChecker<charT,traitsT>,NodeNameChecker<charT,traitsT> > super_type;
  public:
    /**
     * RXgN^
     *
     * \param type ^Cv
     * \param name O
     */
    NamedNodeFinder(NodeType type,const string_type& name)
      : super_type(std::logical_and<bool>(),
		   NodeTypeChecker<charT,traitsT>(type),
		   NodeNameChecker<charT,traitsT>(name)){ }
  };

}

#ifndef MIX_FUNCTIONS_CPP_
#include "Functions.cpp"
#endif

#endif
