// -*- mode: c++ -*-
#ifndef MIX_MISC_H_
#define MIX_MISC_H_

/** \file misc
 *   ɒuĂ̂͂Ő錾Ă܂
 */

#include "classes.h"

#include "DefaultTraits.h"

namespace MiX{
  /**
   * m[h̃^Cv\񋓌^ł
   *
   * 4rbg = 0,[IsNodeContainer],[IsNamedNode],[IsValue]
   * 4rbg̓j[NȒl
   */
  enum NodeType{
    Node_Document = 0x40,
    Node_Element = 0x60,
    Node_Attribute = 0x30,
    Node_Text = 0x10,
    Node_Comment = 0x11,
    //ȉ̒l͎ۂ̃m[hɂ͎gpȂB
    Node_NodeContainer = 0x40,
    Node_NamedNode = 0x20,
    Node_Value = 0x10,
  };
  
  ///G[^Cv\񋓌^ł
  enum ErrorType{
    // for ParsingException
    UnexpectedToken = 0,
    XMLDeclarationNotFound,
    InternalError,
    UnexpectedEOD,
    InvalidHandler,
    InvalidDeclaration,
    MismatchTag,
    // for DomException
    NullException,
    NodeNotFound,
    NodeDuplication,
    InvalidNodeFound
  };

  /// toStringȂǂŗp镶Ɏw萔tabǉ֐ł
  template<class charT,class traitsT>
  void insertIndent(int i,XMLString<charT,traitsT>& str,charT c){
    for(int j=0;j<i;j++) str+=c;
  }


#define MiX_Template_Typedef(C,T) typedef C char_type; \
    typedef T traits_type; \
    typedef typename T::char_traits char_traits; \
    typedef typename T::xml_traits xml_traits; \
    typedef Node<C,T> node_type; \
    typedef NodeContainer<C,T> nodecontainer_type; \
    typedef NamedNode<C,T> namednode_type; \
    typedef Value<C,T> value_type; \
    typedef Document<C,T> document_type; \
    typedef Element<C,T> element_type; \
    typedef Attribute<C,T> attribute_type; \
    typedef Text<C,T> text_type; \
    typedef Comment<C,T> comment_type; \
    typedef AttrMap<C,T> attrmap_type; \
    typedef XMLString<C,T> string_type; \
    typedef NodeList<C,T> nodelist_type; 
}

#endif
