/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import sun.misc.BASE64Encoder;

public class PFile {
    static String toolURL = null;
    static String topURL = null;
    static String authBase64 = null;
    String url = null;
    String path = null;

    public static boolean init(String url, String username, String password) {
        try {
            if (username != null && password == null) {
                password = "";
            }
            if (username != null) {
                BASE64Encoder encoder = new BASE64Encoder();
                byte[] b = (username + ":" + password).getBytes();
                authBase64 = encoder.encode(b);
            }
            url = url.trim();
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            URL u = new URL(url + "/plone_sync/absoluteURLOfPloneSyncTool");
            HttpURLConnection c = (HttpURLConnection)u.openConnection();
            if (authBase64 != null) {
                c.setRequestProperty("Authorization", "Basic " + authBase64);
            }
            InputStream is = c.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            toolURL = s.trim();
            topURL = toolURL.substring(0, toolURL.lastIndexOf("/"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public PFile(String url) {
        url = url.trim();
        while (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!url.startsWith(topURL)) {
            System.out.println("PFile. ????" + url);
        }
        this.path = url.substring(topURL.length());
        this.url = url;
    }

    public PFile(PFile pf, String name) {
        name = name.trim();
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        while (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.url = pf.url + "/" + name;
        this.path = this.url.substring(topURL.length());
    }

    public String getName() {
        int i = this.url.lastIndexOf("/");
        if (i == -1) {
            return null;
        }
        return this.url.substring(i + 1);
    }

    public String toString() {
        return this.url;
    }

    public boolean exists() throws PFileException {
        String s = this.get(toolURL + "/exists?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new PFileException("no permission?");
    }

    public boolean mkdir() throws PFileException {
        String s = this.get(toolURL + "/mkdir?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("true")) {
            return true;
        }
        throw new PFileException("no permission, or no parent?");
    }

    public boolean isDirectory() throws PFileException {
        String s = this.get(toolURL + "/isDirectory?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new PFileException("no permission, or not exists?");
    }

    public boolean isFile() throws PFileException {
        String s = this.get(toolURL + "/isFile?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new PFileException("no permission, or not exists?");
    }

    public long lastModified() throws PFileException {
        String s = this.get(toolURL + "/lastModified?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or not exists?");
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new PFileException("unknown error?");
        }
    }

    public boolean setLastModified(long l) throws PFileException {
        String s = toolURL + "/setLastModified?path=" + this.path;
        s = s + "&modTime=" + l;
        if ((s = this.get(s)) == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or not exists?");
        }
        if (s.equals("true")) {
            return true;
        }
        throw new PFileException("unknown error?");
    }

    public String[] list() throws PFileException {
        String s = this.get(toolURL + "/listFiles?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or not exists?");
        }
        if (s.equals("/")) {
            return new String[0];
        }
        if (s.startsWith("/")) {
            s = s.substring(1);
            return s.split("/");
        }
        throw new PFileException("unknown error?");
    }

    public PFile[] listFiles() throws PFileException {
        String[] s = this.list();
        PFile[] pfs = new PFile[s.length];
        for (int i = 0; i < s.length; ++i) {
            pfs[i] = new PFile(this, s[i]);
        }
        return pfs;
    }

    public String[] listRemoved() throws PFileException {
        String s = this.get(toolURL + "/getRemoved?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or not exists?");
        }
        if (s.equals("/")) {
            return new String[0];
        }
        if (s.startsWith("/")) {
            s = s.substring(1);
            return s.split("/");
        }
        throw new PFileException("unknown error?");
    }

    public PFile[] listRemovedFiles() throws PFileException {
        String[] ss = this.listRemoved();
        PFile[] ret = new PFile[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            ret[i] = new PFile(this, ss[i]);
        }
        return ret;
    }

    public boolean isRemoved() throws PFileException {
        String s = this.get(toolURL + "/isRemoved?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or no parent?");
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new PFileException("unknown error?");
    }

    public long getRemovedTime() throws PFileException {
        String s = this.get(toolURL + "/getRemovedTime?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, or no parent, or not removed?");
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public boolean delete() throws PFileException {
        String s = this.get(toolURL + "/delete?path=" + this.path);
        if (s == null) {
            throw new PFileException("network error?");
        }
        if (s.equals("error")) {
            throw new PFileException("no permission, not exists?");
        }
        return s.equals("true");
    }

    public static long siteCurrentTime() throws PFileException {
        try {
            long currentTime;
            String s = toolURL + "/siteCurrentTime";
            URL url = new URL(s);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            if (authBase64 != null) {
                c.setRequestProperty("Authorization", "Basic " + authBase64);
            }
            InputStream is = c.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            s = br.readLine();
            s = s.trim();
            try {
                currentTime = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new PFileException("unknown error?");
            }
            return currentTime;
        }
        catch (Exception e) {
            throw new PFileException("network error?");
        }
    }

    String get(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            if (authBase64 != null) {
                c.setRequestProperty("Authorization", "Basic " + authBase64);
            }
            InputStream is = c.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            s = s.trim();
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getToFile(File f) throws PFileException {
        try {
            String s = this.url.substring(0, this.url.lastIndexOf("/"));
            s = s + "/externalEdit_/";
            s = s + this.getName();
            URL url = new URL(s);
            HttpURLConnection c = (HttpURLConnection)url.openConnection();
            if (authBase64 != null) {
                c.setRequestProperty("Authorization", "Basic " + authBase64);
            }
            InputStream is = c.getInputStream();
            boolean b = false;
            int i = 0;
            while ((i = is.read()) != -1) {
                if (i == 10) {
                    if (b) break;
                    b = true;
                    continue;
                }
                b = false;
            }
            FileOutputStream fos = new FileOutputStream(f);
            int length = 0;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            fos.close();
            is.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("----------");
            e.printStackTrace();
            System.out.println("----------");
            throw new PFileException("[" + this.getName() + "] network error?");
        }
    }

    public boolean putFromFile(File f) throws PFileException {
        try {
            URL u = new URL(this.url);
            HttpURLConnection c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("PUT");
            c.setDoOutput(true);
            if (authBase64 != null) {
                c.setRequestProperty("Authorization", "Basic " + authBase64);
            }
            c.connect();
            OutputStream os = c.getOutputStream();
            FileInputStream fis = new FileInputStream(f);
            int length = 0;
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            fis.close();
            os.close();
            int i = c.getResponseCode();
            c.disconnect();
            if (i >= 200 && i < 300) {
                return true;
            }
            throw new PFileException("[" + this.getName() + "] http error. errorcode is " + i);
        }
        catch (Exception e) {
            throw new PFileException("network error?");
        }
    }
}

