#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# テキストをHTMLの定義リスト(<dl>)に変換するプログラム
# テキストの書式はpukiwikiをお手本にしている．
# 多段のリストなどには対応していない．また，
# 
# このプログラムを外部から
# 使用する時は，text2dl関数に入力ファイル
# と出力ファイルを渡せばよい．
# テキストを入出力に使いたい場合には
# text_to_dl関数を使うとよい．

import sys, glob, string

#後で，出力結果をテキストで取得できるようにす
#ファイルオブジェクト
class Output:
    def __init__(self):
        self.text = ''

    def write(self,string):
        self.text = self.text+string

    def writelines(self,lines):
        for line in lines: self.write(line)

#テキストを入力ファイルとして扱うための
#オブジェクト
class Input:
    def __init__(self, input=''):
        self.text = input

    def read(self, *size):
        if not size:
            res, self.text = self.text, ''
        else:
            res, self.text = self.text[:size[0]], self.text[size[0]:]
        return res

    def readline(self):
        eoln = string.find(self.text, '\n')
        if eoln == -1:
            res, self.text = self.text, ''
        else:
            res, self.text = self.text[:eoln+1], self.text[eoln+1:]
        return res

    def readlines(self):
        res = []
        while True:
            line = self.readline()
            if line == '':
                return res
            else:
                res.append(line)

#表の中の行を表現するクラス

class Row:
    NO_DL_ROW = 0 # 定義リストの行ではない
    DL_ROW = 1 # 定義リストの行である
    def __init__(self,line):
        if line[0] != ':':
            self.type = Row.NO_DL_ROW
            return
        if line[-1]=='\n':
            line = line[:-1]
        pipeIndex = string.find(line,'|')
        if pipeIndex == -1:
            self.type = Row.NO_DL_ROW
            return
        self.dt = line[1:pipeIndex]
        self.dd = line[pipeIndex+1:]
        self.type = Row.DL_ROW
        return

# これがメインの変換関数
# 使う方法は簡単で，入出力ファイルを指定して呼出すだけ．
# なんか複雑になってしまったけど，このメイン関数で
# やっていることは，定義リストの行を抽出してdlリストに保存してゆき，
# 定義リストブロックが終了したら出力を行なうprocessDL関数に
# dlリストをわたす．定義リストと関係ない行はそのまま出力する．
# それだけ．
def text2dl(inFile,outFile):
    lines = inFile.readlines()
    dl = []
    inDL = False
    for line in lines:
        row = Row(line)
        if not inDL:
            if row.type == Row.DL_ROW:
                inDL = True
                dl.append(row)
            else:
                outFile.write(line)
        else:
            if row.type == Row.DL_ROW:
                dl.append(row)
            else:
                processDL(dl,outFile)
                dl = []
                inDL = False
                outFile.write(line)
    if len(dl)!=0:
        processDL(dl,outFile)

# テーブルを実際に出力ファイルに出力する．
# ただそれだけ．
def processDL(dl,outFile):
    outFile.write('<dl>\n  ')
    for l in dl:
        outFile.write('<dt>%s</dt>' % l.dt)
        outFile.write('<dd>%s</dd>\n' % l.dd)
    outFile.write('</dl>\n')

#入出力がファイルでなくてテキストの
#関数
def text_to_dl(inputText):
    i = Input(inputText)
    o = Output()
    text2dl(i,o)
    return o.text

# 以下このスクリプトが直接呼ばれた時の処理
# 
if __name__ == '__main__':
    if len(sys.argv) == 1:
        inFile = sys.stdin
        outFile = sys.stdout
        text2dl(inFile,outFile)
    else:
        for f in sys.argv[1:]:
            g = glob.glob(f);
            if len(g) == 0:
                print '???file %s does not exist???' % f
                continue
            inFile = open(f)
            co = string.rfind(f,'.mm')
            if co == -1:
                ff = f + '.xhtml'
            else:
                ff = f[:co] + '.xhtml'
            outFile = open(ff,'w')
            text2dl(inFile,outFile)
            inFile.close()
            outFile.close()
