/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "mmap.h"
#include "window.h"
#include "camera.h"
#include "net.h"
#include "mesh.h"
#include "mark.h"
#include "mmapthread.h"
#include "color.h"
#include "glarea.h"
#include "mmapconfig.h"
#include "xmlutil.h"

#include "mmapdata.h"

int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	g_thread_init (NULL);
	gdk_threads_init ();
	gdk_threads_enter ();
	{
		gtk_set_locale ();
		gtk_init (&argc, &argv);

		mmap_directory_set ();
		mmap_config_read ();
		net_init ();
		xmlutil_type_init ();

		mmapdata_init ();
		mesh_mmap_init ();
		color_init ();


		mmapthread_init ();

		camera_init ();

		window_create ();

		{
			gchar *path_xml;

			path_xml = g_build_filename (mmap_dir_pkg_config, "Earth.xml", NULL);
			mmap_set_world (path_xml);

			g_free (path_xml);
		}

        /* マーク読み込み時に lon lat alt を xyz に変換している。そのとき、world の半径が必要で
         * world 生成前に mark_read() をしてしまうと、xyz が全部ゼロになってしまう。
         * world の変更でシグナルだすとかするべきなのかも */
		mark_read ();
        window_set_mark_submenu();


		glarea_process_start ();

        util_get_cache_size();

		gtk_main ();
	}
	gdk_threads_leave ();

	mmap_config_write ();
	mark_write ();

	return 0;
}
