/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MARK_H__
#define __MARK_H__

typedef struct {
	gdouble lon;				/* 経度(秒) */
	gdouble lat;				/* 緯度(秒) */
	gdouble alt;				/* 高度(m) */

	gchar *text;

	/* 以下は lon lat alt から計算される */

	/* 経度、緯度、標高から計算される */
	gdouble x;					/* (m) */
	gdouble y;					/* (m) */
	gdouble z;					/* (m) */
	/* 標高がゼロとしたときの座標。２Ｄ表示で使う。 */
	gdouble x0;					/* (m) */
	gdouble y0;					/* (m) */
	gdouble z0;					/* (m) */
} MarkPoint;

typedef struct {
	gchar *text;

	GSList *sl_point;			/* 中身は、MarkPoint */
} Mark;



void mark_set_submenu (GtkWidget * item);
void mark_item_start_sensitive (gboolean bool);
gboolean mark_is_recording (void);
void mark_set_point_from_3d (gdouble lon, gdouble lat, gdouble alt, const gchar * text);

void mark_render (void);

void mark_read (void);
void mark_write (void);

guint mark_add_mark (void);
void mark_del_mark (guint no_mark);
void mark_swap_mark (guint n1, guint n2);
guint mark_get_mark_n (void);
Mark *mark_get_mark (guint no_mark);
void mark_set_mark (guint no_mark, const gchar * name);

guint mark_add_point (guint no_mark);
void mark_del_point (guint no_mark, guint no_point);
void mark_swap_point (guint no_mark, guint n1, guint n2);
guint mark_get_point_n (guint no_mark);
MarkPoint *mark_get_point (guint no_mark, guint no_point);
void mark_set_point (guint no_mark, guint no_point, gdouble lon, gdouble lat, gdouble alt, const gchar * text);

void mark_start (GtkWindow * parent);
void mark_append_menu (GtkUIManager * ui_manager, GtkActionGroup *action_group, guint ui_id);

#endif /* __MARK_H__ */
