/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DEBUG(x) (x)
*/
#define DEBUG(x)

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "util.h"
#include "net.h"
#include "window.h"
#include "camera.h"
#include "glarea.h"

typedef struct {
	gint n;
	gchar *pref;
} Hani;

/*
Hani hani[] = {
	{0, "全国"},

	{1, "北海道"},

	{2, "青森県"}, {3, "岩手県"}, {4, "宮城県"}, {5, "秋田県"}, {6, "山形県"},
	{7, "福島県"},

	{8, "茨城県"}, {9, "栃木県"}, {10, "群馬県"}, {11, "埼玉県"}, {12, "千葉県"}, {13, "東京都"}, {14, "神奈川県"},

	{15, "新潟県"}, {16, "富山県"}, {17, "石川県"}, {18, "福井県"}, {19, "山梨県"},
	{20, "長野県"}, {21, "岐阜県"}, {22, "静岡県"}, {23, "愛知県"},

	{24, "三重県"}, {25, "滋賀県"}, {26, "京都府"}, {27, "大阪府"}, {28, "兵庫県"},
	{29, "奈良県"}, {30, "和歌山県"},

	{31, "鳥取県"}, {32, "島根県"}, {33, "岡山県"}, {34, "広島県"}, {35, "山口県"},

	{36, "徳島県"}, {37, "香川県"}, {38, "愛媛県"}, {39, "高知県"},

	{40, "福岡県"}, {41, "佐賀県"}, {42, "長崎県"}, {43, "熊本県"}, {44, "大分県"},
	{45, "宮崎県"}, {46, "鹿児島県"}, {47, "沖縄県"}
};
*/

Hani hani[] = {
	{0, "全国"},
	{1, "北海道"},
	{2, "青森"}, {3, "岩手"}, {4, "宮城"}, {5, "秋田"}, {6, "山形"}, {7, "福島"},
	{8, "茨城"}, {9, "栃木"}, {10, "群馬"}, {11, "埼玉"}, {12, "千葉"}, {13, "東京"}, {14, "神奈川"},
	{15, "新潟"}, {16, "富山"}, {17, "石川"}, {18, "福井"}, {19, "山梨"}, {20, "長野"}, {21, "岐阜"}, {22, "静岡"}, {23, "愛知"},
	{24, "三重"}, {25, "滋賀"}, {26, "京都"}, {27, "大阪"}, {28, "兵庫"}, {29, "奈良"}, {30, "和歌山"},
	{31, "鳥取"}, {32, "島根"}, {33, "岡山"}, {34, "広島"}, {35, "山口"},
	{36, "徳島"}, {37, "香川"}, {38, "愛媛"}, {39, "高知"},
	{40, "福岡"}, {41, "佐賀"}, {42, "長崎"}, {43, "熊本"}, {44, "大分"}, {45, "宮崎"}, {46, "鹿児島"}, {47, "沖縄"}
};

typedef struct {
	gdouble x;					/* 135度、10分、5.6秒なら 1351005.6 */
	gdouble y;
	gchar *name;
} Result;

enum {
	LIST_NAME,
	LIST_X,
	LIST_Y,
	LIST_N
};

static GtkWidget *dialog;
static GtkWidget *entry_searchwords;
static GtkWidget *cb_chuki;
static GtkWidget *cb_koukyou;
static GtkRadioButton *rb_hani;

static gint start = 0;
static gint n_result = 0;

static GtkWidget *list_widget;
static GtkWidget *label_result;
static GtkWidget *b_prev;
static GtkWidget *b_next;

/********************************************************************/

static gchar
get_hani (void)
{
	gint n;
	gint i;
	GSList *slist_group = NULL;
	GSList *sl = NULL;
	const gchar *rb_char = NULL;
	gint n_ret = 0;

	slist_group = gtk_radio_button_get_group (rb_hani);

	for (sl = slist_group; sl != NULL; sl = sl->next) {
		GtkRadioButton *rb = sl->data;

		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rb)) == TRUE) {
			rb_char = gtk_button_get_label (GTK_BUTTON (rb));

			DEBUG (g_print ("hani:rb_char:%s:\n", rb_char));

			break;
		}
	}

	n = sizeof hani / sizeof (Hani);
	for (i = 0; i < n; ++i) {
		if (g_ascii_strcasecmp (hani[i].pref, rb_char) == 0) {
			n_ret = hani[i].n;
		}
	}

	/*
	   g_print("get_hani:%d\n", n_ret);
	 */

	return n_ret;
}

static void
list_row_activated_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data)
{
	gchar *name;
	gdouble x, y;
	GtkTreeIter iter;
	GtkTreeModel *model;

	DEBUG (g_print ("list_row_activated_cb\n"));

	model = gtk_tree_view_get_model (treeview);
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, LIST_NAME, &name, -1);
	gtk_tree_model_get (model, &iter, LIST_X, &x, -1);
	gtk_tree_model_get (model, &iter, LIST_Y, &y, -1);

	DEBUG (g_print ("x:%.2f y:%.2f name:%s\n", x, y, name));

	g_print ("x:%.2f y:%.2f name:%s\n", x, y, name);

	g_free (name);

	camera_set_position (x, y);

	glarea_force_update_and_render ();
}

static gchar *
utf_to_url (const gchar * s)
{
	gchar *t = NULL;
	gchar *s_sjis;
	gsize byte_read;
	gsize byte_write;
	GError *err = NULL;
	gint i;

	s_sjis = g_convert (s, strlen (s), "SHIFT_JIS", "UTF-8", &byte_read, &byte_write, &err);
	if (err != NULL) {
		g_print ("utf_to_url:g_convert:%s:%s\n", s, err->message);

		g_error_free (err);
		g_free (s_sjis);

		return g_strdup ("");
	}

	if (byte_write == 0) {
		g_free (s_sjis);

		return g_strdup ("");
	}

	for (i = 0; i < byte_write; ++i) {
		gchar *moji;

		if (g_ascii_isalnum (s_sjis[i]) == TRUE || s_sjis[i] == '.' || s_sjis[i] == '-' || s_sjis[i] == '_') {
			moji = g_strdup_printf ("%c", s_sjis[i]);
		} else if (s_sjis[i] == ' ') {
			moji = g_strdup_printf ("%c", '+');
		} else {
			moji = g_strdup_printf ("%%%.2X", s_sjis[i] & 0xff);
		}

		if (t == NULL) {
			t = g_strdup (moji);
		} else {
			gchar *tmp;

			tmp = g_strconcat (t, moji, NULL);
			g_free (t);
			t = tmp;
		}
		g_free (moji);
	}

	g_free (s_sjis);

	return t;
}

static void
make_list_data_sub (GtkTreeIter * iter, const gchar * text, gdouble x, gdouble y)
{
	GtkTreeView *treeview = GTK_TREE_VIEW (list_widget);
	GtkTreeModel *model;

	model = gtk_tree_view_get_model (treeview);

	gtk_list_store_append (GTK_LIST_STORE (model), iter);
	gtk_list_store_set (GTK_LIST_STORE (model), iter, LIST_NAME, text, -1);
	gtk_list_store_set (GTK_LIST_STORE (model), iter, LIST_X, x, -1);
	gtk_list_store_set (GTK_LIST_STORE (model), iter, LIST_Y, y, -1);
}

static void
line_analysis_sub(const gchar *line, GtkTreeIter *iter)
{
    gchar *start;
    gchar *end;
    gint n;
    gchar *tmp;

    gchar *mark;
    gdouble lon, lat;
    gchar *text0, *text1, *text2;
    gchar *all;

    start = (gchar *)line;
    end = g_strstr_len(line, 20, "&nbsp;<a");
    n = end - start;
    mark = g_strndup(start, n);

    g_print("mark:%s\n", mark);

    start = g_strrstr(line, "latitude=");
	start += strlen ("latitude=");
    end = g_strrstr(line, "&longitude=");
    n = end - start;
    tmp = g_strndup(start, n);
	sscanf (tmp, "%le", &lat);
    g_free(tmp);

    start = g_strrstr(line, "longitude=");
	start += strlen ("longitude=");
    end = g_strrstr(line, "\" target=");
    n = end - start;
    tmp = g_strndup(start, n);
	sscanf (tmp, "%le", &lon);
    g_free(tmp);

    g_print("lon:%e lat:%e\n", lon, lat);

    start = g_strrstr(line, "_top\">");
	start += strlen ("_top\">");
    end = g_strrstr(line, "</a>");
    n = end - start;
    text0 = g_strndup(start, n);

    g_print("text0:%s\n", text0);

    start = g_strrstr(line, "（");
	start += strlen ("（");
    end = g_strrstr(line, "）");
    n = end - start;
    /* 公共施設名には読みがないので括弧が見付からない */
    if( start != NULL && end != NULL){
        text1 = g_strndup(start, n);
    }else{
        text1 = g_strdup("");
    }

    g_print("text1:%s\n", text1);

    start = g_strrstr(line, "/&nbsp;&nbsp;");
	start += strlen ("/&nbsp;&nbsp;");
    text2 = g_strdup(start);

    g_print("text2:%s\n", text2);

    all = g_strconcat(mark, " ", text0, " ", text1, " ", text2, NULL);

    make_list_data_sub (iter, all,  lon, lat);

    g_print("text:%s: lon:%e lat:%e\n", all, lon, lat);

    g_free(mark);
    g_free(text0);
    g_free(text1);
    g_free(text2);
}

static void
line_analysis (const gchar * line)
{
	gchar *start;				/* 切りだしたい文字列の前にある文字列 */
	gchar *end;
	gint n;						/* start と end に囲まれた文字数 */
	gchar *tmp;
    gchar **token;
    gchar **p;
    GtkTreeIter iter;

	DEBUG (g_print ("line_analysis:%s\n", line));


    /* 結果の必要部分の切り出し */
	start = g_strrstr (line, "left;\">");
	start += strlen ("left;\">");
	end = g_strrstr (line, "<br></p>"); /* 最後の <br> を入れるのは、空要素が最後に付くのを防ぐため */
	n = end - start;

	tmp = g_strndup (start, n);
	token = g_strsplit (tmp, "<br>", 0);

	g_print ("####:%s:\n", tmp);

	g_free (tmp);

    for(p = token; *p != NULL; ++p){
        g_print("##%s##\n", *p);
        line_analysis_sub(*p, &iter);
    }

	g_strfreev (token);

	DEBUG (g_print ("x:%.2f y:%.2f name:%s\n", result->x, result->y, result->name));
}

static int
get_n_result(const gchar *line)
{
    gchar *start;
    gchar *end;
    gint len;
    gchar *tmp;
    gint n;

	start = g_strrstr (line, "(");
    start += strlen("(");
	end = g_strrstr (line, "件");
    len = end - start;

    tmp = g_strndup(start, len);
	sscanf (tmp, "%d", &n);
    g_free(tmp);

    return n;
}

/* 引数の html は utf8 */
static void
html_analysis (const gchar * html)
{
	gchar **token = NULL;
	gchar **p;
    gchar *line0 = NULL;   /* 検索結果の数が入った行 */
    gchar *line1 = NULL;   /* ◯〜◯件の文字と[次へ]と[前へ]のリンクが入った行 */
    gchar *line2 = NULL;   /* 検索結果本体の行 */
    gboolean prev = FALSE;
    gboolean next = FALSE;

	if (html == NULL) {
		return;
	}

	token = g_strsplit (html, "\n", 0);

	for(p = token; *p != NULL; ++p) {
		if (g_strrstr (*p, "large") != NULL) {
            line0 = *p;
            ++p;
            line1 = *p;
            ++p;
            line2 = *p;

            break;
		}
	}

    n_result = get_n_result(line0);
    {
        gchar *label;
        gint s;
        gint e;

        if( n_result == 0){
            s = 0;
        }else{
            s = start + 1;
        }

        if( n_result < start + 50){
            e = n_result;
        }else{
            e = start + 50;
        }

        label = g_strdup_printf("検索結果 %d 件中 ( %d - %d )", n_result, s,  e);
        gtk_label_set_text(GTK_LABEL(label_result), label);

        g_free(label);
    }
    /*
    g_print("n:%d\n", n_result);
    */
    g_print("n:%d\n", n_result);

    if(g_strrstr(line1, "前へ") == NULL){
        prev = FALSE;
    }else{
        prev = TRUE;
    }

    if(g_strrstr(line1, "次へ") == NULL){
        next = FALSE;
    }else{
        next = TRUE;
    }
    gtk_widget_set_sensitive(b_prev, prev);
    gtk_widget_set_sensitive(b_next, next);

    /*
    util_print_bool("prev:", prev);
    util_print_bool("next:", next);
    */
    util_print_bool("prev:", prev);
    util_print_bool("next:", next);

    if(n_result != 0){
	    line_analysis (line2);
    }

    g_print("line0:%s\n", line0);
    g_print("line1:%s\n", line1);
    g_print("line2:%s\n", line2);

	g_strfreev (token);
}


static gchar
check_button_get_t_or_f(GtkWidget *button)
{
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(button)) == TRUE){
            return 't';
    }else{
            return 'f';
    }
}

static gchar *
get_uri(void)
{
	gchar *uri;
	const gchar *searchwords_utf;
	gchar *searchwords;
    gchar chuki;
    gchar koukyou;
	gint pref;					/* 検索範囲 */

	searchwords_utf = gtk_entry_get_text (GTK_ENTRY (entry_searchwords));
	searchwords = utf_to_url (searchwords_utf);
	pref = get_hani ();
    chuki = check_button_get_t_or_f(cb_chuki);
    koukyou = check_button_get_t_or_f(cb_koukyou);

	uri = g_strdup_printf ("http://watchizu.gsi.go.jp/search.aspx?searchwords=%s&start=%d&pref=%d&chuki=%c&koukyou=%c",
                                 searchwords, start, pref, chuki, koukyou);
	DEBUG (g_print (":%s:%s:\n", searchwords, uri));

	g_free (searchwords);

	return uri;
}

static void
search_start (void)
{
	gchar *uri;
	gchar *html_sjis;
	gchar *html_utf;
    gint size;
	GtkTreeView *treeview = GTK_TREE_VIEW (list_widget);
	GtkTreeModel *model;

    /* 結果のクリアー */
	model = gtk_tree_view_get_model (treeview);
	gtk_list_store_clear (GTK_LIST_STORE (model));

    n_result = 0;

	uri = get_uri ();
	html_sjis = net_download (uri, &size);

	g_print ("size:%d byte uri:%s\n", size, uri);

	g_free (uri);

	if (html_sjis == NULL) {
		return;
	}

	html_utf = util_to_utf (html_sjis, SJIS);
	free (html_sjis);

	DEBUG (g_print ("html%s\n", html_utf));
	g_print ("html%s\n", html_utf);

	html_analysis (html_utf);
	g_free (html_utf);
}

static void
search_button_clicked_cb (GtkButton * button, gpointer user_data)
{
    start = 0;
    n_result = 0;
	search_start ();
}

static void
clear_button_clicked_cb (GtkButton * button, gpointer user_data)
{
	gtk_entry_set_text (GTK_ENTRY (entry_searchwords), "");
}

static GtkWidget *
create_taisyou (void)
{
	GtkWidget *vbox;
	GtkWidget *frame;

    cb_chuki = gtk_check_button_new_with_label ("地名等注記");
    cb_koukyou = gtk_check_button_new_with_label ("公共施設等");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_chuki), TRUE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cb_koukyou), TRUE);

	vbox = gtk_vbox_new (FALSE, 1);
	gtk_box_pack_start (GTK_BOX (vbox), cb_chuki, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), cb_koukyou, FALSE, FALSE, 0);

	frame = gtk_frame_new ("検索対象");
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	return frame;
}

static GtkWidget *
create_hani_sub (const gchar * text, gint start, gint end, GtkWidget * rbutton[])
{
	gint i;
	GtkWidget *hbox;
	GtkWidget *label;

	label = gtk_label_new (text);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	for (i = start; i < end + 1; ++i) {
		gtk_box_pack_start (GTK_BOX (hbox), rbutton[i], FALSE, FALSE, 0);
	}

	return hbox;
}

static GtkWidget *
create_hani (void)
{
	GtkWidget *frame;
	GtkWidget *line;
	GtkWidget *vbox;
	GtkWidget *rbutton[48];
	gint i;

	rbutton[0] = gtk_radio_button_new_with_label (NULL, hani[0].pref);
	rb_hani = GTK_RADIO_BUTTON (rbutton[0]);
	for (i = 1; i < 48; ++i) {
		rbutton[i] = gtk_radio_button_new_with_label_from_widget (rb_hani, hani[i].pref);
	}

	vbox = gtk_vbox_new (FALSE, 1);

	line = create_hani_sub ("全国　　：", 0, 0, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("北海道　：", 1, 1, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("東北地方：", 2, 7, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("関東地方：", 8, 14, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("中部地方：", 15, 23, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("近畿地方：", 24, 30, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("中国地方：", 31, 35, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("四国地方：", 36, 39, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	line = create_hani_sub ("九州地方：", 40, 47, rbutton);
	gtk_box_pack_start (GTK_BOX (vbox), line, FALSE, FALSE, 0);

	frame = gtk_frame_new ("検索範囲");
	gtk_container_set_border_width (GTK_CONTAINER (frame), 3);
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	return frame;
}

static void
entry_activate_cb (GtkEntry * entry, gpointer user_data)
{
    start = 0;
    n_result = 0;
	search_start ();
}

static GtkWidget *
create_moji (void)
{
	GtkWidget *vbox;
	GtkWidget *frame;

	entry_searchwords = gtk_entry_new ();
	g_signal_connect (entry_searchwords, "activate", G_CALLBACK (entry_activate_cb), NULL);
	gtk_entry_set_width_chars (GTK_ENTRY (entry_searchwords), 8);

	vbox = gtk_vbox_new (FALSE, 3);
	gtk_box_pack_start (GTK_BOX (vbox), entry_searchwords, FALSE, FALSE, 5);

	frame = gtk_frame_new ("検索文字");
	gtk_container_add (GTK_CONTAINER (frame), vbox);

	return frame;
}


static void
prev_clicked_cb(GtkButton *button, gpointer   user_data)
{
    start -= 50;
	search_start ();
}

static void
next_clicked_cb(GtkButton *button, gpointer   user_data)
{
    start += 50;
	search_start ();
}

static GtkWidget *
create_kekka (void)
{
    GtkWidget *hbox;
    GtkWidget *vbox;
	GtkWidget *frame;
	GtkWidget *scroll;
	GtkListStore *list_store;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;

	list_store = gtk_list_store_new (LIST_N, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
	list_widget = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
	g_signal_connect (list_widget, "row-activated", G_CALLBACK (list_row_activated_cb), NULL);
	g_object_unref (G_OBJECT (list_store));

    gtk_tree_view_set_headers_visible (GTK_TREE_VIEW(list_widget), FALSE);

	column = gtk_tree_view_column_new ();

	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, renderer, "text", LIST_NAME, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (list_widget), column);

	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scroll), list_widget);

	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_add (GTK_CONTAINER (frame), scroll);

    label_result = gtk_label_new("検索結果");
    b_prev = gtk_button_new_with_label("前へ");
    b_next = gtk_button_new_with_label("次へ");
    gtk_widget_set_sensitive(b_prev, FALSE);
    gtk_widget_set_sensitive(b_next, FALSE);
	g_signal_connect (b_prev, "clicked", G_CALLBACK (prev_clicked_cb), NULL);
	g_signal_connect (b_next, "clicked", G_CALLBACK (next_clicked_cb), NULL);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), label_result, TRUE, TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), b_prev, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), b_next, FALSE, FALSE, 5);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);

	return vbox;
}

static void
dialog_response_cb (GtkDialog * dialog, gint arg1, gpointer user_data)
{
	GtkTreeView *treeview = GTK_TREE_VIEW (list_widget);
	GtkTreeModel *model;
	GtkListStore *liststore;
    GtkAction *action = GTK_ACTION(user_data);

	g_print ("dialog_response_cb\n");

	model = gtk_tree_view_get_model (treeview);
	g_print ("dialog_response_cb\n");
	liststore = GTK_LIST_STORE (model);
	g_print ("dialog_response_cb\n");
	/*
	   g_object_unref(liststore);
	 */
	gtk_widget_destroy (GTK_WIDGET (dialog));


    gtk_action_set_sensitive(action, TRUE);
}

void
mmapsearch_dialog_create (GtkAction *action)
{
	GtkWidget *taisyou;
	GtkWidget *hani;
	GtkWidget *moji;
	GtkWidget *kekka;

	GtkWidget *vbox;
	GtkWidget *hbox;

	GtkWidget *button1;
	GtkWidget *button2;
	GtkWidget *vbox_button;

    gtk_action_set_sensitive(action, FALSE);

	hani = create_hani ();
	taisyou = create_taisyou ();
	moji = create_moji ();
	kekka = create_kekka ();

	button1 = gtk_button_new_with_label(_("Search"));
	button2 = gtk_button_new_with_label(_("Clear"));
	g_signal_connect (button1, "clicked", G_CALLBACK (search_button_clicked_cb), NULL);
	g_signal_connect (button2, "clicked", G_CALLBACK (clear_button_clicked_cb), NULL);
	vbox_button = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox_button), button1, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (vbox_button), button2, TRUE, TRUE, 2);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), taisyou, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), moji, TRUE, TRUE, 5);
	gtk_box_pack_start (GTK_BOX (hbox), vbox_button, FALSE, FALSE, 5);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hani, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), kekka, TRUE, TRUE, 0);

	dialog = gtk_dialog_new_with_buttons (_("GSI Search"), NULL,
										  GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
	g_signal_connect (G_OBJECT (dialog), "response", G_CALLBACK (dialog_response_cb), action);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);
	gtk_window_set_default_size (GTK_WINDOW (dialog), 220, 600);
	gtk_widget_show_all (dialog);
}
