/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_IMAGE_H__
#define __WW_IMAGE_H__

#include <gtk/gtk.h>

#include "ww_object.h"

G_BEGIN_DECLS
#define WW_TYPE_IMAGE                 (ww_image_get_type ())
#define WW_IMAGE(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_IMAGE, WwImage))
#define WW_IMAGE_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_IMAGE, WwImageClass))
#define WW_IS_IMAGE(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_IMAGE))
#define WW_IS_IMAGE_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_IMAGE))
#define WW_IMAGE_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_IMAGE, WwImageClass))
typedef struct _WwImage WwImage;
typedef struct _WwImageClass WwImageClass;

struct _WwImage {
	WwObject parent;
};

struct _WwImageClass {
	WwObjectClass parent_class;
};

GType ww_image_get_type (void);

WwObject *ww_image_new (void);


G_END_DECLS
#endif /* __WW_IMAGE_H__ */
