/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
 */
#define DB(x)

#include "config.h"

#include "ww_data.h"
#include "ww_object.h"
#include "ww_layerset.h"
#include "util.h"
#include "layermanager.h"
#include "mmapconfig.h"

typedef struct _WwLayersetPrivate WwLayersetPrivate;
struct _WwLayersetPrivate {
	gboolean dispose_has_run;

	/*****/

	GSList *sl_layers;			/* (WwObject *) */
	GSList *sl_childlayerset;	/* WwLayerset *child_layer_set */


	/* attribute */
	gboolean show_only_one_layer;
};

#define WW_LAYERSET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_LAYERSET, WwLayersetPrivate))

static WwObjectClass *parent_class = NULL;

static void ww_layerset_class_init (WwLayersetClass * klass);
static void ww_layerset_init (WwLayerset * object);
static void ww_layerset_finalize (GObject * object);
static void ww_layerset_dispose (GObject * object);
static GObject *ww_layerset_constructor (GType type, guint n_props, GObjectConstructParam * props);
static void ww_layerset_interface_init (gpointer g_iface, gpointer iface_data);

/*****************************************************************************/

static void ww_layerset_set_attribute (WwData * data, const gchar ** name, const gchar ** value);
static void ww_layerset_set_element (WwData * data, const gchar * element0, const gchar * element1,
									 const gchar * value);
static void ww_layerset_set_parent (WwData * data, WwData * parent);
static void ww_layerset_set_child (WwData * data, WwData * child);

static void ww_layerset_update (WwObject * obj);
static void ww_layerset_render (WwObject * obj);
static void ww_layerset_set_on (WwObject * obj, gboolean is_on);
static void ww_layerset_set_layermanager_menu (WwObject * obj, GtkTreeIter * iter_parent);
static void ww_layerset_debug_print (WwObject * obj);

/*****************************************************************************/

GType
ww_layerset_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwLayersetClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_layerset_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwLayerset),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_layerset_init
		};

		static const GInterfaceInfo ww_data_info = {
			(GInterfaceInitFunc) ww_layerset_interface_init,	/* interface_init */
			NULL,				/* interface_finalize */
			NULL				/* interface_data */
		};

		type = g_type_register_static (WW_TYPE_OBJECT, "WwLayerset", &info, 0);

		g_type_add_interface_static (type, WW_TYPE_DATA, &ww_data_info);

		g_print ("ww_layerset_get_type\n");
	}

	return type;
}

static void
ww_layerset_class_init (WwLayersetClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	WwObjectClass *wwobject_class = WW_OBJECT_CLASS (klass);

	/*
	   g_print ("ww_layerset_class_init:c:%p:\n", klass);
	 */

	g_type_class_add_private (klass, sizeof (WwLayersetPrivate));

	parent_class = g_type_class_peek_parent (klass);
	/*
	   g_print ("######ww_layerset_class_init:parent_class:%p:    wwobject_class:%p: layerset_class:%p\n", parent_class,
	   wwobject_class, klass);
	 */

	object_class->constructor = ww_layerset_constructor;
	object_class->finalize = ww_layerset_finalize;
	object_class->dispose = ww_layerset_dispose;

	wwobject_class->update = ww_layerset_update;
	wwobject_class->render = ww_layerset_render;
	wwobject_class->set_on = ww_layerset_set_on;
	wwobject_class->set_layermanager_menu = ww_layerset_set_layermanager_menu;

	wwobject_class->debug_print = ww_layerset_debug_print;
}

static void
ww_layerset_init (WwLayerset * self)
{
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (self);

	/*
	   g_print ("ww_layerset_init:self:o:%p:\n", self);
	 */

	priv->dispose_has_run = FALSE;
	priv->sl_layers = NULL;
	priv->sl_childlayerset = NULL;
	priv->show_only_one_layer = FALSE;
}

static void
ww_layerset_dispose (GObject * obj)
{
	WwLayerset *self = WW_LAYERSET (obj);
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (self);
	GSList *sl;

	/*
	   g_print ("dispose\n");
	 */

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;

	for (sl = priv->sl_layers; sl != NULL; sl = sl->next) {
		WwObject *wwo = (WwObject *) sl->data;

		g_object_unref (wwo);
		sl->data = NULL;
	}

	for (sl = priv->sl_childlayerset; sl != NULL; sl = sl->next) {
		WwLayerset *ls = (WwLayerset *) sl->data;

		g_object_unref (ls);
	}

	g_slist_free (priv->sl_layers);
	g_slist_free (priv->sl_childlayerset);

	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_layerset_finalize (GObject * obj)
{
	WwLayerset *self = WW_LAYERSET (obj);
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (self);

	/*
	   g_print ("finalize\n");
	 */

	g_slist_free (priv->sl_layers);

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_layerset_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);

	/*
	   g_print ("constructor\n");
	 */

	object = object_class->constructor (type, n_props, props);

	return object;
}

static void
ww_layerset_interface_init (gpointer g_iface, gpointer iface_data)
{
	WwDataInterface *iface = (WwDataInterface *) g_iface;
	iface->set_attribute = ww_layerset_set_attribute;
	iface->set_element = ww_layerset_set_element;
	iface->set_parent = ww_layerset_set_parent;
	iface->set_child = ww_layerset_set_child;
}


WwObject *
ww_layerset_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_LAYERSET, NULL);

	/*
	   g_print ("ww_layerset_new:o:%p\n", object);
	 */

	return WW_OBJECT (object);
}

/********************************************************************/

static void
ww_layerset_update (WwObject * obj)
{
	GSList *sl;
	WwLayerset *layerset = WW_LAYERSET (obj);
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (layerset);

	if (obj->is_on == FALSE) {
		return;
	}

	/*
	   g_print ("ww_layerset_update:%s\n", obj->name);
	 */

	for (sl = priv->sl_layers; sl != NULL; sl = sl->next) {
		WwObject *wwo = (WwObject *) sl->data;

		ww_object_update (wwo);
	}
	for (sl = priv->sl_childlayerset; sl != NULL; sl = sl->next) {
		WwLayerset *ls = (WwLayerset *) sl->data;

		ww_object_update ((WwObject *) ls);
	}
}

static void
ww_layerset_render (WwObject * obj)
{
	GSList *sl;
	WwLayerset *layerset = WW_LAYERSET (obj);
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (layerset);

	if (obj->is_on == FALSE) {
		return;
	}

	/*
	   g_print ("ww_layerset_render:%s\n", obj->name);
	 */

	for (sl = priv->sl_layers; sl != NULL; sl = sl->next) {
		WwObject *wwo = (WwObject *) sl->data;

		ww_object_render (wwo);
	}
	for (sl = priv->sl_childlayerset; sl != NULL; sl = sl->next) {
		WwLayerset *ls = (WwLayerset *) sl->data;

		ww_object_render ((WwObject *) ls);
	}
}

static void
ww_layerset_set_on (WwObject * obj, gboolean is_on)
{
	WwObject *obj_parent = obj->wwparent;

	if (is_on == TRUE && WW_IS_LAYERSET (obj_parent)) {
		/* is_on == TRUE の時のみでないと、ループする */
		ww_layerset_check_show_only_one_layer (WW_LAYERSET (obj_parent));
	}

	parent_class->set_on (obj, is_on);
}


static void
ww_layerset_set_attribute (WwData * data, const gchar ** name, const gchar ** value)
{
	gint i;
	WwLayerset *obj = WW_LAYERSET (data);
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (obj);
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);
	/*
	   g_print ("ww_layersetset_attribute:o:%p name:%s: value:%s:\n", obj, name[0], value[0]);
	 */
	for (i = 0; name[i] != NULL; ++i) {
		DB (g_print ("ww_layerset_set_attribute:name:%s: value:%s:\n", name[i], value[i]));

		if (g_ascii_strcasecmp (name[i], "Name") == 0) {
			/* LayerSet だけ attribute で name があたえられ、element にはない。 */
			WW_OBJECT (obj)->name = g_strdup (value[i]);

		} else if (g_ascii_strcasecmp (name[i], "ShowOnlyOneLayer") == 0) {
			priv->show_only_one_layer = util_char_to_boolean (value[i]);

		} else {
			;
		}
	}

	parent_wwdata_iface->set_attribute (data, name, value);
}

static void
ww_layerset_set_element (WwData * data, const gchar * element0, const gchar * element1, const gchar * value)
{
	WwLayerset *obj = WW_LAYERSET (data);
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);
	g_print ("ww_layer_set_element:o:%p e0:%s e1:%s value:%s\n", obj, element0, element1, value);

	/* 独自の element を持たない */

	parent_wwdata_iface->set_element (data, element0, element1, value);
}

static void
ww_layerset_set_parent (WwData * data, WwData * parent)
{
	WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);

	/* 親のままでいい */
	parent_wwdata_iface->set_parent (data, parent);
}

static void
ww_layerset_set_child (WwData * data, WwData * child)
{
	WwLayerset *obj = WW_LAYERSET (data);
	WwLayersetPrivate *priv;
	/*
	   WwDataInterface *parent_wwdata_iface = g_type_interface_peek (parent_class, WW_TYPE_DATA);
	 */

	if (obj == NULL) {
		return;
	}

	priv = WW_LAYERSET_GET_PRIVATE (obj);
	if (WW_IS_LAYERSET (child) == TRUE) {
		priv->sl_childlayerset = g_slist_append (priv->sl_childlayerset, child);
	} else {
		priv->sl_layers = g_slist_append (priv->sl_layers, child);
	}

	g_object_ref (child);

	/* chain up する必要なし 
	   parent_wwdata_iface->set_child (data, child);
	 */
}

gboolean
ww_layerset_is_show_only_one_layer (WwLayerset * layerset)
{
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (layerset);

	return priv->show_only_one_layer;
}

static void
ww_layerset_set_layermanager_menu (WwObject * obj, GtkTreeIter * iter_parent)
{
	GtkTreeIter iter;
	GSList *sl;
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (obj);
    gboolean is_on = FALSE;
    gboolean exist = FALSE;

	/*
	   g_print ("ww_layerset_set_layermanager_menu:o:%p\n", obj);
	 */
    is_on = mmap_config_get_bool(obj->name, &exist);
    if(exist == TRUE){
        obj->is_on = is_on;
    }else{
        mmap_config_set_bool(obj->name, obj->is_on);
    }

	layermanager_append (&iter, iter_parent);
	layermanager_set_item (&iter, obj->is_on, obj->name, obj);

	for (sl = priv->sl_layers; sl != NULL; sl = sl->next) {
		WwObject *o = (WwObject *) sl->data;

		ww_object_set_layermanager_menu (o, &iter);
	}

	for (sl = priv->sl_childlayerset; sl != NULL; sl = sl->next) {
		WwLayerset *ls = (WwLayerset *) sl->data;

		ww_object_set_layermanager_menu ((WwObject *) ls, &iter);
	}
}

void
ww_layerset_check_show_only_one_layer (WwLayerset * layerset)
{
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (layerset);
	/*
	   g_print ("ww_layerset_check_show_only_one_layer\n");
	 */
	g_return_if_fail (layerset != NULL);
	g_return_if_fail (WW_IS_LAYERSET (layerset));

	if (priv->show_only_one_layer == TRUE) {
		GSList *sl;

		for (sl = priv->sl_layers; sl != NULL; sl = sl->next) {
			WwObject *obj = (WwObject *) sl->data;

			ww_object_set_on (obj, FALSE);
		}
		for (sl = priv->sl_childlayerset; sl != NULL; sl = sl->next) {
			WwLayerset *ls = (WwLayerset *) sl->data;

			ww_object_set_on ((WwObject *) ls, FALSE);
		}
	}
}

static void
ww_layerset_debug_print (WwObject * obj)
{
	WwLayersetPrivate *priv = WW_LAYERSET_GET_PRIVATE (obj);

	g_print ("ww_layerset_debug_print##########\n");

	parent_class->debug_print (obj);

	/*
	   GSList *sl_layers;
	   WwLayerset *child_layer_set;
	 */
	util_print_bool ("\t show_only_one_layer:", priv->show_only_one_layer);
}
