/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __XMLUTIL_H__
#define __XMLUTIL_H__

typedef struct _XmlData XmlData;

void xmlutil_push_object (XmlData * xmldata, gint state, gpointer object, const gchar * element);
void xmlutil_push_element (XmlData * xmldata, const gchar * element);

gpointer xmlutil_pop_object (XmlData * xmldata);
void xmlutil_pop_element (XmlData * xmldata);

gint xmlutil_get_state (XmlData * xmldata);
const gchar *xmlutil_get_element0 (XmlData * xmldata);
const gchar *xmlutil_get_element1 (XmlData * xmldata);
gpointer xmlutil_get_object (XmlData * xmldata);

gpointer xmlutil_get_result (XmlData * xmldata);

void xmlutil_xmldata_free (XmlData * xmldata);

XmlData *xmlutil_prepare (const gchar * filename, GMarkupParser * parser);

void xmlutil_type_init (void);
gpointer xmlutil_data_build (const gchar * path_xml);

#endif /* __XMLUTIL_H__ */
