/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>
#include <math.h>

#include <gtk/gtk.h>

#include "mmap.h"
#include "mesh.h"
#include "ww_terrainaccessor.h"
#include "util.h"
#include "color.h"
#include "gsi.h"

gdouble *
mesh_create_st (gint nx, gint ny, WwMeshType type)
{
	gint i, j;
	gint c;
	gdouble *st;

	/*
	   g_print ("mesh_create_st:%d\n", type);
	 */

	st = g_new (gdouble, (nx + 1) * (ny + 1) * 2);

	c = 0;
	for (j = 0; j < ny + 1; ++j) {
		for (i = 0; i < nx + 1; ++i) {
			gdouble s, t;

			s = (gdouble) i / nx;
			t = 1.0 - (gdouble) j / ny;

			if (type == WW_MESH_TYPE_NORMAL) {
				/*
				   s = s;
				   t = t;
				 */
			} else if (type == WW_MESH_TYPE_NORTH_WEST) {
				s = s / 2.0;
				t = t / 2.0;
			} else if (type == WW_MESH_TYPE_NORTH_EAST) {
				s = s / 2.0 + 0.5;
				t = t / 2.0;
			} else if (type == WW_MESH_TYPE_SOUTH_WEST) {
				s = s / 2.0;
				t = t / 2.0 + 0.5;
			} else if (type == WW_MESH_TYPE_SOUTH_EAST) {
				s = s / 2.0 + 0.5;
				t = t / 2.0 + 0.5;
			}

			*(st + 2 * c + 0) = s;
			*(st + 2 * c + 1) = t;

			++c;
		}
	}
	/*
	   g_print ("mesh_create_st:c:%d\n", c);
	 */

	return st;
}

/* ****************
 * 現在、経度が180度をまたぐ場合は使えない。
 * (x0,y0):左下
 * (x1,y1):右上
 * ***********************要変更******************:
 */

/* 全部標高ゼロ版 */
gdouble *
mesh_create_deg_alt0 (gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx, gint ny)
{
	gint i, j;
	gint c;
	gdouble *v;
	gdouble dx, dy;

	dx = (x1 - x0) / nx;
	dy = (y1 - y0) / ny;

	v = g_new (gdouble, (nx + 1) * (ny + 1) * 3);

	c = 0;
	for (j = 0; j < ny + 1; ++j) {
		for (i = 0; i < nx + 1; ++i) {
			*(v + 3 * c + 0) = x0 + i * dx;
			*(v + 3 * c + 1) = y0 + j * dy;
			*(v + 3 * c + 2) = 0.0;
			++c;
		}
	}

	return v;
}

/* 親の標高データを使って作る。４点を同じ標高にする */
gdouble *
mesh_create_deg_copy (gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx, gint ny, WwMeshType type,
					  gdouble * v_deg_parent)
{
	gint i, j;
	gint c;
	gdouble *v;
	gdouble dx, dy;
	gint x_offset = 0;
	gint y_offset = 0;

	if (type == WW_MESH_TYPE_NORMAL) {
		g_print ("mesh_create_deg_copy:WW_MESH_TYPE_NORMAL ??????\n");	/* ありえない */
		exit (1);
	} else if (type == WW_MESH_TYPE_NORTH_WEST) {
		y_offset = ny / 2;
	} else if (type == WW_MESH_TYPE_NORTH_EAST) {
		x_offset = nx / 2;
		y_offset = ny / 2;
	} else if (type == WW_MESH_TYPE_SOUTH_WEST) {
		;
	} else if (type == WW_MESH_TYPE_SOUTH_EAST) {
		x_offset = nx / 2;
	}

	dx = (x1 - x0) / nx;
	dy = (y1 - y0) / ny;

	v = g_new (gdouble, (nx + 1) * (ny + 1) * 3);

#if 0
	c = 0;
	for (j = 0; j < ny + 1; ++j) {
		g_print ("p(%d):", j);

		for (i = 0; i < nx + 1; ++i) {
			g_print ("%.0f ", *(v_deg_parent + 3 * c + 2));

			++c;
		}
		g_print ("\n");
	}

	g_print ("create_v_deg_copy:type %d   x_off:%d y_off:%d   \n", type, x_offset, y_offset);
#endif

	c = 0;
	for (j = 0; j < ny + 1; ++j) {
		for (i = 0; i < nx + 1; ++i) {
			gint ii, jj;
			gint k;

			ii = i / 2 + x_offset;
			jj = j / 2 + y_offset;

			k = ii + (nx + 1) * jj;

			/*
			   g_print ("  ii:%d jj:%d k:%d   %.2f\n", ii, jj, k, *(v_deg_parent + 3 * k + 2));
			 */

			*(v + 3 * c + 0) = x0 + i * dx;
			*(v + 3 * c + 1) = y0 + j * dy;
			*(v + 3 * c + 2) = *(v_deg_parent + 3 * k + 2);
			++c;
		}
	}

	return v;
}

/* 標高を terrain_tile から取る版 */
gdouble *
mesh_create_deg (gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx, gint ny, WwTerrainaccessor * ta)
{
	gint i, j;
	gint c;
	gdouble *v;
	gdouble dx, dy;

	dx = (x1 - x0) / nx;
	dy = (y1 - y0) / ny;

	v = g_new (gdouble, (nx + 1) * (ny + 1) * 3);


	c = 0;
	for (j = 0; j < ny + 1; ++j) {
		for (i = 0; i < nx + 1; ++i) {
			gdouble x, y;

			x = x0 + i * dx;
			y = y0 + j * dy;

			*(v + 3 * c + 0) = x;
			*(v + 3 * c + 1) = y;
			*(v + 3 * c + 2) = ww_terrainaccessor_get_alt (ta, x, y);
			/*
			   g_print("mesh_create_deg:%.2f %.2f ::: %.2f\n", x, y, *(v + 3 * c + 2));
			 */
			++c;
		}
	}

	return v;
}

void
mesh_change_xyz (gdouble * v_deg, gdouble * v_xyz, gint nx, gint ny, gdouble above_surface, gdouble multi)
{
	gint i;
	gint n;

	n = (nx + 1) * (ny + 1);
	for (i = 0; i < n; ++i) {
		gdouble *v;
		gdouble x, y, z;

		v = v_deg + i * 3;
		mmap_deg_to_xyz (*(v + 0), *(v + 1), *(v + 2) * multi + above_surface, &x, &y, &z);
		/*
		   g_print("mesh_change_xyz:%.2f %.2f %.2f\n", *(v + 0), *(v + 1), *(v + 2)); 
		 */
		*(v_xyz + i * 3 + 0) = x;
		*(v_xyz + i * 3 + 1) = y;
		*(v_xyz + i * 3 + 2) = z;
	}
}

gdouble *
mesh_create_xyz (gdouble * v_deg, gint nx, gint ny, gdouble above_surface, gdouble multi)
{
	gint i;
	gdouble *v_xyz;
	gint n;

	v_xyz = g_new (gdouble, (nx + 1) * (ny + 1) * 3);

	n = (nx + 1) * (ny + 1);
	for (i = 0; i < n; ++i) {
		gdouble *v;
		gdouble x, y, z;

		v = v_deg + i * 3;
		mmap_deg_to_xyz (*(v + 0), *(v + 1), *(v + 2) * multi + above_surface, &x, &y, &z);
		/*
		   g_print("mesh_create_xyz:%.2f %.2f %.2f\n", *(v + 0), *(v + 1), *(v + 2)); 
		 */
		*(v_xyz + i * 3 + 0) = x;
		*(v_xyz + i * 3 + 1) = y;
		*(v_xyz + i * 3 + 2) = z;
	}

	return v_xyz;
}


/* 頂点配列のインデックス
 * nx, ny ：分割数
 */
guint *
mesh_create_index (gint nx, gint ny)
{
	guint i, j;
	guint *index;
	gint n;						/* 全頂点数：左下からはじまって、その上の頂点に戻ってくるまでの頂点数×縦の分割数 */
	gint c;

	n = ((nx + 1) * 2 + 2) * ny;
	index = g_new (guint, n);

	DB (g_print ("create_index:n:%d\n", n));

	c = 0;
	for (j = 0; j < ny; ++j) {
		for (i = 0; i < nx + 1; ++i) {
			*(index + c) = i + j * (nx + 1);
			++c;
			*(index + c) = i + (j + 1) * (nx + 1);
			++c;
		}
		*(index + c) = nx + (j + 1) * (nx + 1);
		++c;
		*(index + c) = 0 + (j + 1) * (nx + 1);
		++c;
	}

	return index;
}

/*******************************************************/

/**** mmap 用 上の double を float にかえただけのものがあるのでかなり無駄。どうにかする。 */

#include <gtk/gtkgl.h>
#include <GL/gl.h>
#include <GL/glext.h>

static guint *index_mmap = NULL;
static guint index_name_mmap = 0;
static guint ni_mmap = 0;

static gdouble *t_st_mmap = NULL;
static guint t_st_name_mmap = 0;
static guint nt_mmap = 0;

guint *
mesh_mmap_i_init (void)
{
	return index_mmap;
}

guint
mesh_mmap_index_buffer_name (void)
{
	return index_name_mmap;
}

gdouble *
mesh_mmap_t_st_init (void)
{
	return t_st_mmap;
}

guint
mesh_mmap_t_st_buffer_name (void)
{
	return t_st_name_mmap;
}

gdouble *
mesh_mmap_v_deg_init (gdouble x, gdouble y, gint nx, gint ny)
{
	gdouble x0, y0;
	gdouble x1, y1;

	x0 = x / 3600.0;
	y0 = y / 3600.0;

	x1 = (x + W_SECOND + 1.0) / 3600.0;
	y1 = (y + H_SECOND) / 3600.0;

	return mesh_create_deg_alt0 (x0, y0, x1, y1, nx, ny);
}

void
mesh_mmap_v_xyz_change (gdouble * v_deg, gdouble * v_xyz, gint nx, gint ny, gdouble multi)
{
	return mesh_change_xyz (v_deg, v_xyz, nx, ny, 0.0, multi);
}

gdouble *
mesh_mmap_v_xyz_init (gdouble * v_deg, gint nx, gint ny, gdouble multi)
{
	return mesh_create_xyz (v_deg, nx, ny, 0.0, multi);
}

static void
normalize (const gdouble * s, gdouble * d)
{
	float l;

	l = sqrtf (s[0] * s[0] + s[1] * s[1] + s[2] * s[2]);
	d[0] = s[0] / l;
	d[1] = s[1] / l;
	d[2] = s[2] / l;
}

gdouble *
mesh_mmap_n_init (gdouble * v_xyz, gint nx, gint ny)
{
	gint i;
	gint n;
	gdouble *nor;

	n = (nx + 1) * (ny + 1);
	nor = g_new (gdouble, n * 3);

	for (i = 0; i < n; ++i) {
		gint k = i * 3;

		normalize (v_xyz + k, nor + k);
	}
	return nor;
}

/* 色を付けかえる */
void
mesh_mmap_c_calc (gdouble * c, gdouble * v_deg, gint nv)
{
	gint i;

	for (i = 0; i < nv; ++i) {
		gint alt;
		gint k = i * 3;

		alt = *(v_deg + k + 2);

		if (alt < 0) {
			*(c + k + 0) = 0.7;
			*(c + k + 1) = 0.8;
			*(c + k + 2) = 1.0;
		} else {
			guint8 r, g, b;

			color_get_rgb_from_alt (alt, &r, &g, &b);
			*(c + k + 0) = (gdouble) r / 0xff;
			*(c + k + 1) = (gdouble) g / 0xff;
			*(c + k + 2) = (gdouble) b / 0xff;
		}
	}
}

double *
mesh_mmap_c_init (gint nx, gint ny)
{
	gint i;
	gint n;
	gdouble *c;

	n = (nx + 1) * (ny + 1);
	c = g_new (gdouble, n * 3);

	for (i = 0; i < n; ++i) {
		gint k = i * 3;

		*(c + k + 0) = 1.0;
		*(c + k + 1) = 1.0;
		*(c + k + 2) = 1.0;
	}

	return c;
}

void
mesh_mmap_gl_init (void)
{
#ifdef GL_VERSION_1_5
	/*
	   g_print ("mesh_mmap_gl_init:nt_mmap:%d  ni_mmap:%d\n", nt_mmap, ni_mmap);
	   g_print ("t_st_name_mmap:nt*4*sizeof:%d\n", nt_mmap * 2 * sizeof (gdouble));
	 */

	glGenBuffers (1, &t_st_name_mmap);
	glBindBuffer (GL_ARRAY_BUFFER, t_st_name_mmap);
	glBufferData (GL_ARRAY_BUFFER, nt_mmap * 2 * sizeof (gdouble), t_st_mmap, GL_STATIC_DRAW);
	g_free (t_st_mmap);
	t_st_mmap = NULL;			/* gl****Pointer で使うので NULL を入れておく */
	/*
	   g_print ("t_st_name_mmap:%hd\n", t_st_name_mmap);
	 */

	glBindBuffer (GL_ARRAY_BUFFER, 0);

	glGenBuffers (1, &index_name_mmap);
	glBindBuffer (GL_ELEMENT_ARRAY_BUFFER, index_name_mmap);
	glBufferData (GL_ELEMENT_ARRAY_BUFFER, ni_mmap * sizeof (guint), index_mmap, GL_STATIC_DRAW);
	g_free (index_mmap);
	index_mmap = NULL;
	/*
	   g_print ("index_name_mmap  n:%hd    name:%d\n", ni_mmap, index_name_mmap);
	 */

	glBindBuffer (GL_ELEMENT_ARRAY_BUFFER, 0);
#endif
}


void
mesh_mmap_init (void)
{
	gint nx, ny;				/* 分割数 */

	nx = (W_SECOND + 1) / 2;	/* 113 */
	ny = H_SECOND / 2;			/* 75 */

	nt_mmap = (nx + 1) * (ny + 1);
	ni_mmap = ((nx + 1) * 2 + 2) * ny;

	t_st_mmap = mesh_create_st (nx, ny, WW_MESH_TYPE_NORMAL);
	index_mmap = mesh_create_index (nx, ny);

}
