/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>

#include <gtk/gtk.h>
#include <curl/curl.h>

#include "mmapthread.h"
#include "net.h"

/************************/

typedef struct {
	gint n;						/* この pool に溜っている数 */
	gchar *key;					/* 同じサーバーであることを識別するための文字列 http://sample.com/data/ なら http://sample.com  */

	CURL *curl;
	GMutex *mutex;				/* curl を書き換える時に使う */
	GThreadPool *pool;

} DownloadThreadPool;

static GSList *sl_downloadthreadpool = NULL;	/* 中身は DownloadThreadPool */




static gpointer thread_func_download (gpointer data, gpointer user_data);


static gchar *
get_key_from_uri (const gchar * uri)
{
	gchar *key = NULL;
	gchar *p;

	p = (gchar *) uri;

	/* こんなのでいいのか？ */
	if (*p == 'h') {
		++p;
	}
	if (*p == 't') {
		++p;
	}
	if (*p == 't') {
		++p;
	}
	if (*p == 'p') {
		++p;
	}
	if (*p == ':') {
		++p;
	}
	if (*p == '/') {
		++p;
	}
	if (*p == '/') {
		++p;
	}

	for (; p != '\0'; ++p) {
		if (*p == '/') {
			key = g_strndup (uri, p - uri);
			break;
		}
	}

	return key;
}

static DownloadThreadPool *
get_downloadpool (const gchar * uri)
{
	GSList *sl;
	gchar *key;
	DownloadThreadPool *dpool = NULL;

	key = get_key_from_uri (uri);
	if (key == NULL) {
		return NULL;
	}

	for (sl = sl_downloadthreadpool; sl != NULL; sl = sl->next) {
		DownloadThreadPool *dt = (DownloadThreadPool *) (sl->data);

		/*
		   g_print("get_downloadpool:%d:%s:\n", dt->n, dt->key);
		 */

		if (g_ascii_strcasecmp (key, dt->key) == 0) {
			dpool = dt;
			break;
		}
	}

	if (dpool == NULL) {
		gint n;
		GError *err = NULL;
		DownloadThreadPool *dt_new;

		dt_new = g_new (DownloadThreadPool, 1);
		dt_new->n = 0;
		dt_new->key = g_strdup (key);
		dt_new->curl = NULL;
		dt_new->mutex = g_mutex_new ();
		dt_new->pool = g_thread_pool_new ((GFunc) thread_func_download, NULL, 1, TRUE, &err);
		if (err != NULL) {
			g_print ("error:get_download_pool:%s\n", err->message);
			exit (1);
		}

		sl_downloadthreadpool = g_slist_prepend (sl_downloadthreadpool, dt_new);
		n = g_slist_length (sl_downloadthreadpool);
		g_print ("################################################################ %d\n", n);


		dpool = dt_new;
	}

	g_free (key);

	return dpool;
}

/************************/

typedef struct {
	MmapThreadFunc func;
	GObject *obj;
	DownloadThreadPool *pool;
} ThreadData;

static GThreadPool *pool_power = NULL;
static gint n_power = 0;
static gint n_download = 0;

gint
mmapthread_get_n_download (void)
{
	return n_download;
}

void *
mmapthread_download_get (const gchar * uri, gint * return_bytes)
{
	void *data;
	DownloadThreadPool *dpool;

	dpool = get_downloadpool (uri);

	data = net_download_get (dpool->curl, uri, return_bytes);

	return data;
}


static gpointer
thread_func_download (gpointer data, gpointer user_data)
{
	ThreadData *td = data;
	GObject *obj = G_OBJECT (td->obj);

	g_mutex_lock (td->pool->mutex);
	if (td->pool->curl == NULL) {
		td->pool->curl = net_download_set ();
	}
	g_mutex_unlock (td->pool->mutex);

	td->func (obj);

	/* これをしないことで keep-alive  ?
	   g_mutex_lock(td->pool->mutex);
	   net_download_cleanup(td->pool->curl);
	   td->pool->curl = NULL;
	   g_mutex_unlock(td->pool->mutex);
	 */


	g_object_unref (obj);
	g_free (td);

	td->pool->n -= 1;
	--n_download;

	return NULL;
}

static gpointer
thread_func_power (gpointer data, gpointer user_data)
{
	ThreadData *td = data;

	if (td->obj == NULL) {
		td->func (NULL);

	} else {
		GObject *obj = G_OBJECT (td->obj);
		td->func (obj);
		g_object_unref (obj);
	}

	g_free (td);

	--n_power;

	return NULL;
}

void
mmapthread_add_power (MmapThreadFunc func, GObject * obj)
{
	ThreadData *td;
	GError *err = NULL;

	if (obj != NULL) {
		g_object_ref (obj);
	}

	/*
	   g_print ("mmapthread_add_power:%d\n",g_thread_pool_unprocessed(pool_power));
	 */

	td = g_new (ThreadData, 1);
	td->func = func;
	td->obj = obj;
	td->pool = NULL;

	++n_power;
	g_thread_pool_push (pool_power, td, &err);
	if (err != NULL) {
		g_print ("error!:mmapthread_add_power:g_thread_pool_push:%s\n", err->message);
		exit (1);
	}
}

/************************/



void
mmapthread_add_download2 (const gchar * uri, MmapThreadFunc func, GObject * obj)
{
	ThreadData *td;
	GError *err = NULL;
	DownloadThreadPool *downloadpool;

	downloadpool = get_downloadpool (uri);
	if (downloadpool == NULL) {
		g_print ("????????????????????????????????????? mmapthread_add_downlaod2 \n");
		exit (1);
	}

	g_object_ref (obj);

	td = g_new (ThreadData, 1);
	td->func = func;
	td->obj = obj;
	td->pool = downloadpool;
	td->pool->n += 1;

	/*
	   g_print ("mmapthread_add_download2:%d:::::%s\n",g_thread_pool_unprocessed(downloadpool->pool), uri);
	 */

	++n_download;
	g_thread_pool_push (downloadpool->pool, td, &err);
	if (err != NULL) {
		g_print ("error!:mmapthread_add_download2:g_thread_pool_push:%s\n", err->message);
		exit (1);
	}
}


/************************************/

void
mmapthread_init (void)
{
	GError *err = NULL;

/*
	g_print ("mmapthread_init\n");
    */

	pool_power = g_thread_pool_new ((GFunc) thread_func_power, NULL, 1, TRUE, &err);
	if (err != NULL) {
		g_print ("error:pool_power:%s\n", err->message);
		exit (1);
	}
}
