/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_TERRAINACCESSOR_H__
#define __WW_TERRAINACCESSOR_H__

#include <gtk/gtk.h>

#include "ww_data.h"

G_BEGIN_DECLS
#define WW_TYPE_TERRAINACCESSOR             (ww_terrainaccessor_get_type ())
#define WW_TERRAINACCESSOR(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_TERRAINACCESSOR, WwTerrainaccessor))
#define WW_TERRAINACCESSOR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_TERRAINACCESSOR, WwTerrainaccessorClass))
#define WW_IS_TERRAINACCESSOR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_TERRAINACCESSOR))
#define WW_IS_TERRAINACCESSOR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_TERRAINACCESSOR))
#define WW_TERRAINACCESSOR_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_TERRAINACCESSOR, WwTerrainaccessorClass))
typedef struct _WwTerrainaccessor WwTerrainaccessor;
typedef struct _WwTerrainaccessorClass WwTerrainaccessorClass;

struct _WwTerrainaccessor {
	GObject parent;
};

struct _WwTerrainaccessorClass {
	GObjectClass parent_class;
};

GType ww_terrainaccessor_get_type (void);

WwTerrainaccessor *ww_terrainaccessor_new (void);


void ww_terrainaccessor_set_higher_resolution_subsets (WwTerrainaccessor * parent, WwTerrainaccessor * child);

WwTerrainaccessor *ww_terrainaccessor_select (WwTerrainaccessor * ta, gdouble x0, gdouble y0, gdouble x1, gdouble y1);

void ww_terrainaccessor_data_prepare (WwTerrainaccessor * ta, gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx,
									  gint ny);
void ww_terrainaccessor_read_data (WwTerrainaccessor * ta, gdouble x0, gdouble y0, gdouble x1, gdouble y1, gint nx,
								   gint ny);
gdouble ww_terrainaccessor_get_alt (WwTerrainaccessor * ta, gdouble lon, gdouble lat);

void ww_terrainaccessor_debug_print (WwTerrainaccessor * ta);
const gchar *ww_terrainaccessor_get_server_url (WwTerrainaccessor * obj);

G_END_DECLS
#endif /* __WW_TERRAINACCESSOR_H__ */
