/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MMAP_H__
#define __MMAP_H__


#include <gtk/gtk.h>

#include "ww_world.h"

extern gchar *mmap_dir_pkg;
extern gchar *mmap_dir_pkg_config;
extern gchar *mmap_dir_pkg_data;

extern gchar *mmap_dir;
extern gchar *mmap_dir_cache;
extern gchar *mmap_dir_data;
extern gchar *mmap_dir_gsi;
extern gchar *mmap_dir_gsi_tex;
extern gchar *mmap_dir_gsi_vn;

void mmap_directory_set (void);

/**************/

gdouble mmap_get_vertical_exaggeration (void);
void mmap_set_vertical_exaggeration (gdouble n);

typedef enum {
	MMAP_VIEW_MODE_2D,
	MMAP_VIEW_MODE_3D,
} MmapViewMode;

MmapViewMode mmap_get_view_mode (void);
void mmap_set_view_mode (MmapViewMode mode);

void mmap_set_world (const gchar * worldname);

gdouble mmap_get_world_radius (void);
void mmap_deg_to_xyz (gdouble lon, gdouble lat, gdouble alt, gdouble * x, gdouble * y, gdouble * z);
const gchar *mmap_get_world_name (void);
WwTerrainaccessor *mmap_get_terrainaccessor (gdouble x0, gdouble y0, gdouble x1, gdouble y1);

void mmap_render (void);
void mmap_update (void);

typedef void (*MmapIdleFunc) (GObject *);
void mmap_idle_add_single (MmapIdleFunc func, GObject * obj);

/**************/

#endif /* __MMAP_H__ */
