/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __SIMPLEMATH_H__
#define __SIMPLEMATH_H__

void matrix4_inverse (gdouble m[], gdouble ret[]);
void mul_mat4_mat4 (gdouble m0[], gdouble m1[], gdouble ret[]);
void mul_mat4_vec4 (gdouble m[], gdouble v[], gdouble ret[]);

void quaternion_normalize (gdouble q[]);
void qmul (const gdouble p[], const gdouble q[], gdouble r[]);
void quaternion_to_matrix (const double q[], gdouble m[]);

void quaternion_to_euler (const gdouble q[], gdouble * yaw, gdouble * pitch, gdouble * roll);
void euler_to_quaternion (gdouble yaw, gdouble pitch, gdouble roll, gdouble q[]);

gdouble distance_degree (gdouble lon0, gdouble lat0, gdouble lon1, gdouble lat1);

#define RAD(x)  (2.0 * G_PI / 360.0 * (x))
#define DEG(x)  (360.0 / 2.0 / G_PI * (x))

void debug_print_matrix (gdouble m[]);

#endif /* __SIMPLEMATH_H__ */
