/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_TEXTURELOADER_H__
#define __WW_TEXTURELOADER_H__

#include <gtk/gtk.h>

#include "ww_texture.h"

G_BEGIN_DECLS
#define WW_TYPE_TEXTURELOADER                (ww_textureloader_get_type ())
#define WW_TEXTURELOADER(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_TEXTURELOADER, WwTextureloader))
#define WW_TEXTURELOADER_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_TEXTURELOADER, WwTextureloaderClass))
#define WW_IS_TEXTURELOADER(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_TEXTURELOADER))
#define WW_IS_TEXTURELOADER_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_TEXTURELOADER))
#define WW_TEXTURELOADER_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_TEXTURELOADER, WwTextureloaderClass))
typedef struct _WwTextureloader WwTextureloader;
typedef struct _WwTextureloaderClass WwTextureloaderClass;

struct _WwTextureloader {
	GObject parent;
};

struct _WwTextureloaderClass {
	GObjectClass parent_class;
};

typedef GdkPixbuf *(*ImageManipulateFunc) (GObject *, GdkPixbuf *);

GType ww_textureloader_get_type (void);

WwTextureloader *ww_textureloader_new (void);
void ww_textureloader_set_source (WwTextureloader * loader,
								  const gchar * path_tex, const gchar * path_img, const gchar * uri, gint tex_w, gint tex_h);
void ww_texture_loader_set_image_manipulate_func (WwTextureloader * loader, ImageManipulateFunc func, GObject * data);
void ww_textureloader_start (WwTextureloader * loader);

void ww_textureloader_set_texture (WwTextureloader * loader, WwTexture * texture);
WwTexture *ww_textureloader_get_texture (WwTextureloader * loader);

WwTextureloader *ww_textureloader_lookup (const gchar * uri);

G_END_DECLS
#endif /* __WW_TEXTURELOADER_H__ */
