#ifndef MOF_AMBIENT_LIGHT
#define MOF_AMBIENT_LIGHT

#include "mof/Light.hpp"
#include "mof/Color.hpp"
#include <boost/scoped_ptr.hpp>


namespace mof{



class AmbientLight : public Light{
	struct Impl;
	boost::scoped_ptr<Impl> m_pImpl;

public:
	AmbientLight( mof::Color4f color = mof::Color4f(1 , 1 , 1));
	virtual ~AmbientLight();

	virtual void setEnable(bool enable);

	virtual void setFrameNumber(mof::FrameNumber frame);
	virtual void nextFrame();
	virtual void prevFrame();

};

}


#endif
