#pragma once
#include "mof/tstring.hpp"
#include "mof/real.hpp"

namespace mof{
	typedef unsigned int Color;
	typedef unsigned char ColorChannel;
	Color createColor(ColorChannel r , ColorChannel g , ColorChannel b);
	Color createColor(ColorChannel a , ColorChannel r , ColorChannel g , ColorChannel b);
	Color createColor(const mof::tstring& code);
	ColorChannel getRed(const Color& color);
	ColorChannel getGreen(const Color& color);
	ColorChannel getBlue(const Color& color);
	ColorChannel getAlpha(const Color& color);
	Color blendColor( Color a , Color b , real rate );
	Color inverseColor( Color color );
	mof::tstring toColorCode( Color color );

	struct Color4f{
		real red;
		real green;
		real blue;
		real alpha;

		Color4f();
		Color4f(real alpha_ , real red_ , real green_ , real blue_);
		Color4f( real red_ , real green_ , real blue_);
		explicit Color4f(mof::Color color);
		mof::Color toColorCode() const;

		mof::Color4f operator +( const mof::Color4f& rhs ) const ;
		mof::Color4f operator -( const mof::Color4f& rhs ) const ;
        mof::Color4f operator *( const Color4f& rhs ) const;

		friend mof::Color4f operator *(const Color4f& color , real f);
		friend mof::Color4f operator *(real f ,  const mof::Color4f & color);
	    friend std::ostream& operator <<(std::ostream& os , const mof::Color4f& obj );

	};

	

	
};
