#pragma once
#include "mof/stream/utilities.hpp"

namespace mof
{

    class Component2D
    {
    public:
        virtual ~Component2D( ){}

        /** コンポーネントの左上の位置を得る
         *  @note   このメソッドで得られるハンドラとsetPosition()で
         *          指定したハンドラは同一であると扱える
         *  @retval このウィジェットの左上の位置を得るためのハンドラ 
         */
        virtual const Vector2DStream& getPositionStream( ) const
        {
            return m_positionStream;
        }
        
        /** コンポーネントの左上の位置を得る
         *  @note   このメソッドで得られるハンドラとsetPosition()で
         *          指定したハンドラは同一であると扱える
         *  @retval このウィジェットの左上の位置を得るためのハンドラ 
         */
        virtual Vector2DStream& getPositionStream( ) 
        {
            return m_positionStream;
        }


        /** コンポーネントの左上の位置を指定する
         *  @note   このメソッドで指定するハンドラとgetPosition()で
         *          得られるハンドラは同一であると扱える
         *  @retval このウィジェットの左上の位置を得るためのハンドラ 
         */
        /*virtual void setSizeStream( const Vector2DStream& stream )
        {
            m_sizeStream = stream;
        }*/
        
        /** コンポーネントの大きさを得る
         *  @note   このメソッドで得られるハンドラとsetSize()で
         *          指定したハンドラは同一であると扱える
         *  @retval このウィジェットの大きさを得るためのハンドラ 
         */
        virtual const Vector2DStream& getSizeStream( ) const
        {
            return m_sizeStream;
        }
        
        /** コンポーネントの大きさを得る
         *  @note   このメソッドで得られるハンドラとsetSize()で
         *          指定したハンドラは同一であると扱える
         *  @retval このウィジェットの大きさを得るためのハンドラ 
         */
        virtual Vector2DStream& getSizeStream( ) 
        {
            return m_sizeStream;
        }


    protected:
        Vector2DStream m_positionStream;
        Vector2DStream m_sizeStream;

        Component2D( )
        : 
            m_positionStream( makeConstantHandler( Vector2D( 0 , 0 ) ) ) ,
            m_sizeStream( makeConstantHandler( Vector2D( 0 , 0 ) ) ) 
        {
        }
        
        Component2D( const Rectangle< int >& region )
        : 
            m_positionStream
            (
                makeConstantHandler
                ( 
                    Vector2D(region.beginX , region.beginY)
                )
            ) ,
            m_sizeStream
            (
                makeConstantHandler
                (
                    Vector2D(region.getWidth() , region.getHeight())
                )
            ) 
        {}

    };
} // namespace mof
