#ifndef MOF_EVENT_SCHEDULER_HPP
#define MOF_EVENT_SCHEDULER_HPP
#include <memory>
#include <boost/function/function0.hpp>
#include <boost/utility.hpp>
#include "mof/stream/Manipulator.hpp"

namespace mof{

class EventCondition;

class EventScheduler : boost::noncopyable{
	struct Impl;
	std::unique_ptr<Impl> m_pImpl;

public:
	typedef boost::function0<void> Action;
	EventScheduler();
	EventScheduler(EventScheduler&& rh);
	~EventScheduler();

	void addEvent(mof::EventCondition* pCondition , const Action& action);
	void addEvent(mof::FrameNumber interval , const Action& action);
	void update();
	void clear();
};

}




#endif
