#pragma once
#include "mof/Component3D.hpp"
#include "mof/ColorComponent.hpp"
#include "mof/Drawable.hpp"
#include "mof/Texture.hpp"
#include "mof/Material.hpp"
#include "mof/MaterialBuilder.hpp"
#include <memory>

namespace mof
{

	class Graphics3D 
	: 
		public Component3D,
		public ColorComponent,
		public Drawable
	{
	public :
		typedef std::shared_ptr<Graphics3D> ptr;

		virtual ~Graphics3D(){}

		virtual void update() = 0;

		virtual void setTexture
		( 
			unsigned int num,
			const std::shared_ptr<mof::Texture>& pTexture
		) = 0;
		
		/*
		virtual void setMaterialBuilder
		( 
			unsigned int num ,
			const std::shared_ptr<mof::MaterialBuilder>& material_builder
		) = 0;
		*/

		static std::unique_ptr<Graphics3D> create_graphics3d
		(
			const std::vector<VertexXYZCUV>& vertices,
			const Texture::ptr& texture,
			const Material& material
		);// TODO いい名前が思いついたら、クラス化

	};

}// namespace mof

