#include "mof/Timer.hpp"
#include <windows.h>

bool mof::Timer::initialized = false;



mof::Timer::Timer() 
{
	if(!initialized){
		TIMECAPS caps;
		timeGetDevCaps(&caps, sizeof(TIMECAPS)); 
		timeBeginPeriod(caps.wPeriodMin);//ō\Ōv
		initialized = true;
	}
	reset();
	start();
}

void mof::Timer::reset()
{
	m_lastTime = timeGetTime();
	m_pastTime = 0;
}

void mof::Timer::start()
{
	if (m_counting) return;
	m_lastTime = timeGetTime();
	m_counting = true;
}

void mof::Timer::pause()
{
	if (!m_counting) return;
	int time = timeGetTime();
	m_pastTime += time - m_lastTime;
	m_counting = false;
}



int mof::Timer::getTime() const{
	return timeGetTime() - m_lastTime + m_pastTime;
}

unsigned long mof::Timer::getSystemTime()
{
	return timeGetTime();
}

/*
//-----------------------------------------------
// Clock::Clock
// 
//-----------------------------------------------
mof::Clock::Clock()

{
	
	m_begintime = 0;
	

}

//-----------------------------------------------
// Clock::SetTimer
// 
//-----------------------------------------------
void mof::Clock::setTimer(){
	
	m_begintime =  timeGetTime();
	

}


//-----------------------------------------------
// Clock::GetBetweenTime
// 
//-----------------------------------------------
DWORD mof::Clock::getBetweenTime(){
	DWORD temp_time = m_begintime;
	m_begintime = timeGetTime();	
	return m_begintime - temp_time;

}



//	void StopTimer();
//	DWORD GetAvgTime();


//-----------------------------------------------
// Clock::GetFPS
// t[ɂԂAFPSZo
//-----------------------------------------------
float mof::Clock::getFPS(DWORD in_time , UINT in_cnt_frame){
	if(in_time == 0)return 0.0f;//OŏZ
	return (float)in_cnt_frame / (float)in_time * 1000.0f;

}*/
