#include "mof/Vector3D.hpp"
#include <math.h>

mof::Vector3D::Vector3D(real _x , float _y , float _z)
{
	x = _x;
	y = _y;
	z = _z;
}

mof::Vector3D::Vector3D(){
	x = y = z = 0.0f;
}

mof::Vector3D::~Vector3D(void)
{
}


void mof::Vector3D::normalize(){
	real norm = sqrt(x*x + y*y + z*z);
  if(norm < 1E-7 )return ;
	x = x / norm;
	y = y / norm;
	z = z / norm;
}


bool mof::Vector3D::operator ==(const mof::Vector3D& rhs) const{
	if(x == rhs.x && y == rhs.y && rhs.z == z)return true;
	else return false;
}

bool mof::Vector3D::operator != (const mof::Vector3D& obj) const{
	return !(*this == obj);
}
	

mof::Vector3D mof::Vector3D::operator +(const mof::Vector3D& rhs) const{
	return mof::Vector3D(this->x + rhs.x , this->y + rhs.y , this->z + rhs.z);
}


mof::Vector3D mof::Vector3D::operator -(const mof::Vector3D& rhs) const{
	return mof::Vector3D(this->x - rhs.x , this->y - rhs.y , this->z - rhs.z);
}
		
mof::Vector3D mof::Vector3D::operator *(real rhs) const{
	return mof::Vector3D(this->x * rhs , this->y * rhs ,this->z * rhs);
}


mof::Vector3D mof::Vector3D::operator /(real rhs) const{
	return mof::Vector3D(this->x / rhs , this->y / rhs , this->z / rhs);
}
 
 /*
mof::Vector3D mof::operator *(const mof::Vector3D& vec , real f){
	mof::Vector3D obj;
	obj.x = vec.x * f;
	obj.y = vec.y * f;
	obj.z = vec.z * f;
	return obj;
}*/
	
mof::Vector3D mof::operator *(real f , const mof::Vector3D& vec ){
	mof::Vector3D obj;
	obj.x = vec.x * f;
	obj.y = vec.y * f;
	obj.z = vec.z * f;
	return obj;
}

std::ostream& mof::operator <<(std::ostream& os , const mof::Vector3D& obj)
{
	os << '(' << obj.x << ',' << obj.y << ',' << obj.z << ')';
	return os;	
}

