#pragma once
#include <mof/script/ObjectData.hpp>
#include <boost/intrusive/set.hpp>
#include <boost/intrusive/list.hpp>

namespace mof
{
	class Drawable;

namespace script
{
//{{{
	// renderable
	class rendering_packet
	{
		const mof::Drawable* drawable_;
		//boost::function<void (void)>& draw_func_;

		std::shared_ptr<mof::Light> light_;
		int priority_;     // ɕ`悳
		int sub_priority_;// priority΁AŔ肷
		float z_order_;   // ɕ`悳
		bool z_buffer_;   // Zobt@gǂ
		bool is_enable_;//!< IuWFNgXV邩ǂ

	public:
		typedef boost::intrusive::set_member_hook<boost::intrusive::link_mode<boost::intrusive::auto_unlink>> queue_hook_t;
		typedef boost::intrusive::list_member_hook<boost::intrusive::link_mode<boost::intrusive::auto_unlink>> dead_hook_t;
		queue_hook_t queue_hook_;
		dead_hook_t dead_hook_;

		rendering_packet
		(
			const mof::Drawable* drawable,
			int priority,
			bool z_buffer,
			float z_order = 0
		)
			: drawable_(drawable), priority_(priority), sub_priority_(0),
			  z_buffer_(z_buffer), z_order_(z_order), is_enable_(true)
		{
			// sub priorityvZ
			if (!z_buffer_) {
				// Z\[g̃IuWFNg͌ŕ`
				sub_priority_ += 1000;
			}
		}

		inline bool operator <(const rendering_packet& packet) const
		{
			if (priority_ < packet.priority_) return true;
			else if (priority_ > packet.priority_) return false;

			// Dxꍇ
			if (sub_priority_ < packet.sub_priority_) return true;
			else if (sub_priority_ > packet.sub_priority_) return false;

			// Z\[g
			return z_order_ < packet.z_order_;
		}

		inline bool& enable() 
		{
			return is_enable_;
		}
			
		inline const bool& enable() const
		{
			return is_enable_;
		}

		inline void draw() const
		{
			if(!is_enable_)
			{
				// LłȂIuWFNg͕`悳Ȃ
				return;
			}

			// Zobt@gǂ
			if (z_buffer_) GraphicsDevice::setZBuffer(true);
			else GraphicsDevice::setZBuffer(false);

			if (light_) {
				// Cgݒ肳Ă΁Ag
				mof::GraphicsDevice::lightEnable(true);
				light_->setEnable(true);
			}
			else {
				mof::GraphicsDevice::lightEnable(false);
			}
			
			drawable_->draw();
		}

		inline std::shared_ptr<mof::Light>& light()
		{
			return light_;
		}

		// TODO z_oerder_

	};
//}}}
}
}
