#pragma once
#include <mof/stream/Manipulator.hpp>

namespace mof
{
    template< typename T > class Constant;

    template< typename T >
    std::shared_ptr< Constant<T> > makeConstantHandler(const T&);


    template< typename T >
    class Constant : public Manipulator< T >{
    public:
	    typedef typename std::shared_ptr< Constant< T > > Handler;

        virtual ~Constant( ){}
	    
	    virtual T value( FrameNumber ) const
        {
		    return m_value;
	    }


    private:
	    T m_value;
        
        Constant(const T& value) : m_value(value)
        {
	    }

        template< typename T >
        friend std::shared_ptr< Constant<T> > makeConstantHandler(const T&);
    };

//{{{ ヘルパ関数
    template<typename T>
    std::shared_ptr< Constant<T> > makeConstantHandler( const T& value)
    {
	    return typename Constant<T>::Handler(new Constant<T>(value));
    }
//}}}

} // namespace mof


