#pragma once
#include "mof/stream/KeyFrameAnimation.hpp"
#include "mof/Matrix2D.hpp"


namespace mof{

    class Rotation2D : public Manipulator< Matrix2D >
    {
    public:
        typedef std::shared_ptr< Rotation2D > Handler;
	
        Rotation2D
        (
		    const std::pair< FrameNumber , mof::Vector2D >& front , 
		    const std::pair< FrameNumber , mof::Vector2D >& back  
		)
	    {
            m_body = makeKeyFrameAnimationHandler< Vector2D >
                (
                    front , back , &linerInterpolate< Vector2D >
                );
	    }
    
        Rotation2D
        (
 	        const Manipulator< Vector2D >::Handler&  body
 	    )
        : m_body( body )
 	    {
 	    }

	    virtual Matrix2D value( FrameNumber frame ) const
        {
		    return Matrix2D::createRotation( m_body->value(frame) );
	    }

        Manipulator<mof::Vector2D>::Handler get( ) const
        {
            return m_body;
        }
    
        void set( const Manipulator< Vector2D >::Handler& handler ) 
        {
            m_body = handler;
        }

    private:
 	    Manipulator< Vector2D >::Handler  m_body;

    };
//{{{ ヘルパ関数
    inline Rotation2D::Handler makeRotation2DHandler
    (
	    const std::pair< FrameNumber , Vector2D >& front ,
        const std::pair< FrameNumber , Vector2D >& back  
    )
	{
        return Rotation2D::Handler
            (
                new Rotation2D( front , back  )
            );
   	}

    inline Rotation2D::Handler makeRotation2DHandler
    (
 	    const Manipulator< Vector2D >::Handler&  body
    )
	{
        return Rotation2D::Handler
            (
                new Rotation2D( body  )
            );
   	}
//}}}
} // namespace mof
