#pragma once
#include "mof/stream/Manipulator.hpp"
#include <mof/Vector2D.hpp>
#include <mof/GraphicsDevice.hpp>


namespace mof
{
	template <typename T> class world2client_tween;

//{{{ world2client_tween<Vector3D>
	template <>
    class world2client_tween<Vector3D> : public Manipulator<Vector2D>
    {
	    
    public:
		typedef std::shared_ptr<world2client_tween> Handler;
		typedef std::shared_ptr<world2client_tween> ptr; 


    	virtual mof::Vector2D value(frame_t frame) const
        {
			return mof::GraphicsDevice::to2DPosition(m_pBody->value(frame));
	    }


		world2client_tween(const Manipulator<Vector3D>::Handler& pBody)
	    	: m_pBody(pBody) 
	    {
	    }
        
		virtual ~world2client_tween(){}	

    private:
        Manipulator<Vector3D>::Handler m_pBody;

    };
//}}}
//{{{ world2client_tween<Matrix3D> deprecated
	template <>
    class world2client_tween<Matrix3D> : public Manipulator<Vector2D>
    {
	    
    public:
		typedef std::shared_ptr<world2client_tween> ptr; 


    	virtual mof::Vector2D value(frame_t frame) const
        {
			return mof::GraphicsDevice::to2DPosition(mof::Matrix3D::getTranslation(m_pBody->value(frame)));
	    }


		world2client_tween(const Manipulator<Matrix3D>::Handler& pBody)
	    	: m_pBody(pBody) 
	    {
	    }
        
		virtual ~world2client_tween(){}	

    private:
        Manipulator<Matrix3D>::Handler m_pBody;

    };
//}}}
} //namespace mof

